/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.io.File;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.design.BIRTColumnProperties;
import org.projectocolibri.api.birt.design.BIRTDataSet;
import org.projectocolibri.api.birt.design.BIRTDesignHelper;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.language.LABELS;

public class BIRTDesign {
    public static final String DATA_SOURCE = "Database";
    public static final String MASTER_PAGE = "Masterpage";
    private final ReportDesignHandle design = new DesignEngine(new DesignConfig()).newSessionHandle(null).createDesign();
    private final Templates template;

    public static File createEmptyDesign() throws Exception {
        File reportFile = Colibri.FILES.TEMPLATES.parameters.createTempFile();
        ReportDesignHandle design = new BIRTDesign(null).design;
        design.saveAs(reportFile.getAbsolutePath());
        design.close();
        return reportFile;
    }

    public BIRTDesign(Templates template) {
        this.template = template;
    }

    public void create(File designFile) throws Exception {
        this.design.setAuthor(Colibri.PROJECTO_NOME);
        this.design.setCreatedBy(this.template.getManager().getUtilizador().getNomeToText());
        this.design.setTitle(this.template.getDescricao());
        this.design.setDefaultUnits("mm");
        this.design.setInitialize("importPackage( Packages.java.util );\nimportPackage( Packages.java.lang );");
        this.design.getDataSources().add((DesignElementHandle)this.design.getElementFactory().newScriptDataSource(DATA_SOURCE));
        this.design.getMasterPages().add((DesignElementHandle)this.design.getElementFactory().newSimpleMasterPage(MASTER_PAGE));
        this.createParameters();
        this.createStyles();
        this.createDataSets();
        this.design.showError();
        this.design.saveAs(designFile.getAbsolutePath());
        this.design.close();
    }

    private void createParameters() throws Exception {
        BIRTParametersMap.PARAMETERS_TYPES[] pARAMETERS_TYPESArray = BIRTParametersMap.PARAMETERS.get((int)this.template.getTipo().intValue()).array;
        int n = BIRTParametersMap.PARAMETERS.get((int)this.template.getTipo().intValue()).array.length;
        int n2 = 0;
        while (n2 < n) {
            BIRTParametersMap.PARAMETERS_TYPES parameter = pARAMETERS_TYPESArray[n2];
            ScalarParameterHandle param = this.design.getElementFactory().newScalarParameter(parameter.name);
            param.setValueType("static");
            param.setDataType(parameter.type.birt);
            param.setIsRequired(false);
            this.design.getParameters().add((DesignElementHandle)param);
            ++n2;
        }
    }

    private void createStyles() throws Exception {
        StyleHandle style = STYLES.TIME_FORMAT.newStyle(this.design);
        style.setDateTimeFormatCategory("Custom");
        style.setDateTimeFormat(TimeDateUtils.DEFAULT_TIME_PATTERN);
        this.design.getStyles().add((DesignElementHandle)style);
        int i = 0;
        while (i < FIELDS.parametros_formatodata.values.length) {
            style = STYLES.DATE_FORMAT.newStyle(this.design, i);
            style.setDateTimeFormatCategory("Custom");
            style.setDateTimeFormat(FIELDS.parametros_formatodata.values[i]);
            this.design.getStyles().add((DesignElementHandle)style);
            ++i;
        }
        i = 0;
        while (i < 6) {
            style = STYLES.NUMBER_FORMAT.newStyle(this.design, i);
            style.setNumberFormatCategory("Currency");
            style.setNumberFormat("###,##0.0" + StringUtils.replicas((String)"0", (int)i));
            this.design.getStyles().add((DesignElementHandle)style);
            ++i;
        }
        style = STYLES.BACKGROUND_TOP.newStyle(this.design);
        this.design.getElementFactory().newStyle("Background-Bottom");
        style.setProperty("backgroundPositionY", (Object)"bottom");
        this.design.getStyles().add((DesignElementHandle)style);
        style = STYLES.BACKGROUND_BOTTOM.newStyle(this.design);
        style.setProperty("backgroundPositionY", (Object)"top");
        this.design.getStyles().add((DesignElementHandle)style);
    }

    private void addLogoImage(Empresa empresa) throws Exception {
        if (empresa.getLogotipo() != null) {
            EmbeddedImage image = new EmbeddedImage();
            image.setData(empresa.getLogotipo());
            image.setName(LABELS.empresa_logotipo.toString());
            this.design.addImage(image);
        }
    }

    private void createDataSets() throws Exception {
        BIRT_TABLES table = BIRT_TABLES.get(this.template.table());
        ScriptDataSetHandle mainDataSetHandle = this.createDataSet(table.dataSets[0]);
        int i = 1;
        while (i < table.dataSets.length) {
            BIRTDataSet dataSet = table.dataSets[i];
            if (dataSet.sub) {
                this.finalizeDataSet(this.createDataSet(dataSet));
                Debug.out((String)"CREATED", (Object)dataSet.name);
            } else {
                dataSet.create(this.template.getManager().getCampos());
                String fetchScript = mainDataSetHandle.getFetch();
                fetchScript = String.valueOf(fetchScript) + "\n//---------------- " + dataSet.name.toUpperCase() + " ----------------//\n\n";
                fetchScript = String.valueOf(fetchScript) + dataSet.getOpenScript();
                fetchScript = String.valueOf(fetchScript) + dataSet.getFetchScript();
                mainDataSetHandle.setFetch(fetchScript);
                for (BIRTColumnProperties columnProperties : dataSet.getFetchScript()) {
                    BIRTDesignHelper.setColumnProperties(mainDataSetHandle, columnProperties);
                }
                Debug.out((String)"ADDED", (Object)dataSet.name);
            }
            ++i;
        }
        this.finalizeDataSet(mainDataSetHandle);
    }

    private ScriptDataSetHandle createDataSet(BIRTDataSet dataSet) throws Exception {
        dataSet.create(this.template.getManager().getCampos());
        ScriptDataSetHandle dataSetHandle = this.design.getElementFactory().newScriptDataSet(dataSet.name);
        dataSetHandle.setDataSource(DATA_SOURCE);
        dataSetHandle.setBeforeOpen(dataSet.getOpenScript().toText());
        dataSetHandle.setFetch(dataSet.getFetchScript().toText());
        for (BIRTColumnProperties columnProperties : dataSet.getFetchScript()) {
            BIRTDesignHelper.setColumnProperties(dataSetHandle, columnProperties);
        }
        this.design.getDataSets().add((DesignElementHandle)dataSetHandle);
        return dataSetHandle;
    }

    private void finalizeDataSet(ScriptDataSetHandle dataSetHandle) throws Exception {
        String fetchScript = String.valueOf(dataSetHandle.getFetch()) + "\nreturn true;";
        dataSetHandle.setFetch(fetchScript);
        CachedMetaData cachedMetaData = StructureFactory.createCachedMetaData();
        dataSetHandle.setCachedMetaData(cachedMetaData);
    }

    public static enum BIRT_TABLES {
        artigos(new BIRTDataSet(TABLES.artigos), new BIRTDataSet(1, FIELDS.artigos_unidades), new BIRTDataSet(2, FIELDS.artigos_precos), new BIRTDataSet(3, FIELDS.artigos_composicao), new BIRTDataSet(4, FIELDS.artigos_existencias)),
        artigosmovimentos(new BIRTDataSet(TABLES.artigosmovimentos)),
        artigosdocumentos(new BIRTDataSet(TABLES.artigosdocumentos), new BIRTDataSet(1, FIELDS.artigosdocumentos_linhasdocumento)),
        entidades(new BIRTDataSet(TABLES.entidades), new BIRTDataSet(1, FIELDS.entidades_moradas)),
        entidadesmovimentos(new BIRTDataSet(TABLES.entidadesmovimentos), new BIRTDataSet(1, FIELDS.entidadesmovimentos_tabelaiva)),
        entidadesdocumentos(new BIRTDataSet(TABLES.entidadesdocumentos), new BIRTDataSet(1, FIELDS.entidadesdocumentos_linhasdocumento), new BIRTDataSet(2, FIELDS.entidadesdocumentos_entregaspagamento), new BIRTDataSet(3, FIELDS.entidadesdocumentos_tabelaiva), new BIRTDataSet(4, FIELDS.entidadesdocumentos_webservice));

        public BIRTDataSet[] dataSets;

        private BIRT_TABLES(BIRTDataSet ... dataSets) {
            this.dataSets = dataSets;
        }

        public static BIRT_TABLES get(TABLES table) {
            return BIRT_TABLES.valueOf(table.name());
        }
    }

    public static enum STYLES {
        TIME_FORMAT("Time-Format"),
        DATE_FORMAT("Date-Format"),
        NUMBER_FORMAT("Number-Format"),
        BACKGROUND_TOP("Background-Top"),
        BACKGROUND_BOTTOM("Background-Bottom");

        public final String name;

        private STYLES(String name) {
            this.name = name;
        }

        public StyleHandle newStyle(ReportDesignHandle design) {
            return this.newStyle(design, -1);
        }

        public StyleHandle newStyle(ReportDesignHandle design, int index) {
            String name = index == -1 ? this.name : String.valueOf(this.name) + "-" + String.valueOf(index + 1);
            return design.getElementFactory().newStyle(name);
        }
    }
}

