/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.dma.java.util.Debug;
import org.projectocolibri.api.birt.design.BIRTScript;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public class BIRTDataSet {
    public final int index;
    public final boolean sub;
    public final TABLES table;
    public final FIELDS field;
    public final int columns;
    public final String name;
    private final RootFieldsList rootFields = new RootFieldsList();
    private final RootTablesMap rootTables = new RootTablesMap();
    private BIRTScript openScript;
    private BIRTScript fetchScript;

    public BIRTScript getOpenScript() {
        return this.openScript;
    }

    public BIRTScript getFetchScript() {
        return this.fetchScript;
    }

    public BIRTDataSet(TABLES table) {
        this(0, false, table, null, 0);
    }

    public BIRTDataSet(int index, FIELDS field) {
        this(index, field.format.getSize().size == 0, field.childTable, field, field.format.getSize().size);
    }

    private BIRTDataSet(int index, boolean sub, TABLES table, FIELDS field, int columns) {
        Debug.out((String)"table", (Object)((Object)table));
        this.index = index;
        this.sub = sub;
        this.table = table;
        this.field = field;
        this.columns = columns;
        this.name = "d" + String.valueOf(index + 1) + "-" + (Object)((Object)table.label);
        for (TableFieldKey fieldKey : table.map.createLayout(false).exclude(FIELDS.TYPES.TABLE)) {
            FIELDS rootField = table.map.get((TableFieldKey)fieldKey.root()).field;
            switch (rootField.type) {
                default: {
                    this.rootFields.add(fieldKey);
                    break;
                }
                case TABLE: {
                    this.rootTables.add(rootField, fieldKey);
                }
                case SET: 
            }
        }
    }

    public void create(ILabelFormatter formatter) throws Exception {
        this.openScript = this.createOpenScript();
        this.fetchScript = this.createFetchScript(formatter);
    }

    private BIRTScript createOpenScript() throws Exception {
        BIRTScript script = new BIRTScript();
        script.append("iterator_" + this.table.name() + " = ");
        if (this.index == 0) {
            script.append(String.valueOf(this.table.name()) + ".iterator();");
        } else {
            script.append(String.valueOf(this.field.table.name()) + "." + IDatabaseModel.METHODS.GET.name(this.field) + "()" + ".iterator();\n");
        }
        return script;
    }

    private BIRTScript createFetchScript(ILabelFormatter formatter) throws Exception {
        BIRTScript script = new BIRTScript();
        if (this.index == 0 || this.sub) {
            script.append("if( !iterator_" + this.table.name() + ".hasNext() ) return false;\n");
            script.append(String.valueOf(this.table.name()) + " = iterator_" + this.table.name() + ".next();\n");
        } else {
            if (this.columns > 0) {
                script.append("i" + String.valueOf(this.index + 1) + "=1;\n");
            }
            script.append("while( iterator_" + this.table.name() + ".hasNext() ){\n");
            script.append(String.valueOf(this.table.name()) + " = iterator_" + this.table.name() + ".next();\n");
        }
        if (this.columns == 0) {
            this.rootFields.createFetchScript(formatter, script, 0);
            this.rootTables.createFetchScript(formatter, script, 0);
        } else {
            String count = "i" + String.valueOf(this.index + 1);
            int i = 0;
            while (i < this.columns) {
                script.append("//BEGIN COLUMN #" + String.valueOf(i + 1) + "\n");
                script.append("if( " + count + " == " + String.valueOf(i + 1) + " ) {\n");
                this.rootFields.createFetchScript(formatter, script, i);
                this.rootTables.createFetchScript(formatter, script, i);
                script.append("}//END COLUMN #" + String.valueOf(i + 1) + "\n");
                ++i;
            }
            script.append(String.valueOf(count) + "++;\n");
        }
        if (this.index > 0 && !this.sub) {
            script.append("}//END ITERATOR: " + this.table.name() + "\n");
        }
        return script;
    }

    private class RootFieldsList
    extends ArrayList<TableFieldKey> {
        private static final long serialVersionUID = 1L;

        private RootFieldsList() {
        }

        public void createFetchScript(ILabelFormatter formatter, BIRTScript script, int columnNumber) throws Exception {
            for (TableFieldKey fieldKey : this) {
                String columnName = script.createColumn(BIRTDataSet.this.table, formatter, fieldKey, BIRTDataSet.this.index, columnNumber);
                script.append("row[\"" + columnName + "\"] = " + BIRTDataSet.this.table.name() + "." + IDatabaseModel.METHODS.GET.name(fieldKey.name()) + "();\n");
            }
        }
    }

    private class RootTablesMap
    extends LinkedHashMap<FIELDS, Collection<TableFieldKey>> {
        private static final long serialVersionUID = 1L;

        private RootTablesMap() {
        }

        public boolean add(FIELDS field, TableFieldKey fieldKey) {
            if (!this.containsKey(field)) {
                this.put(field, new ArrayList());
            }
            return ((Collection)this.get(field)).add(fieldKey);
        }

        public void createFetchScript(ILabelFormatter formatter, BIRTScript script, int columnNumber) throws Exception {
            for (FIELDS rootField : this.keySet()) {
                script.append("//BEGIN TABLE: " + (Object)((Object)rootField.childTable) + "\n");
                for (TableFieldKey fieldKey : (Collection)this.get(rootField)) {
                    String columnName = script.createColumn(BIRTDataSet.this.table, formatter, fieldKey, BIRTDataSet.this.index, columnNumber);
                    script.append("row[\"" + columnName + "\"] = ");
                    int i = 0;
                    while (i < fieldKey.size() - 1) {
                        if (i > 0) {
                            script.append(" || ");
                        }
                        script.append(BIRTDataSet.this.table.name());
                        int j = 0;
                        while (j <= i) {
                            script.append("." + IDatabaseModel.METHODS.GET.name((String)fieldKey.get(j)) + "()");
                            ++j;
                        }
                        script.append("==null");
                        ++i;
                    }
                    script.append(" ? null : " + BIRTDataSet.this.table.name());
                    i = 0;
                    while (i < fieldKey.size()) {
                        script.append("." + IDatabaseModel.METHODS.GET.name((String)fieldKey.get(i)) + "()");
                        ++i;
                    }
                    script.append(";\n");
                }
                script.append("//END TABLE: " + (Object)((Object)rootField.childTable) + "\n");
            }
        }
    }
}

