/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.PasswordAuthentication;
import org.dma.eclipse.core.DebugLogger;
import org.dma.eclipse.jface.preference.IPreferenceValue;
import org.dma.eclipse.swt.graphics.ImageManager;
import org.dma.java.awt.ImageHandler;
import org.dma.java.email.EmailAddress;
import org.dma.java.email.ServerParameters;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.io.Folder;
import org.dma.java.io.UTF8TextFile;
import org.dma.java.net.HttpURLHandler;
import org.dma.java.security.BlowfishPassword;
import org.dma.java.util.Debug;
import org.dma.java.util.SystemUtils;
import org.dma.java.util.VersionNumber;
import org.dma.services.vies.CheckVatHandler;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.birt.BIRTEngineFactory;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.Label;
import org.projectocolibri.api.language.Language;
import org.projectocolibri.api.language.LanguageBundleMap;
import org.projectocolibri.core.CERTIFICATES;
import org.projectocolibri.core.SERVERS;
import org.projectocolibri.core.remote.RemoteFileHandler;
import org.projectocolibri.core.remote.control.ControlFileHandler;
import org.projectocolibri.core.remote.updates.UpdateFileHandler;
import org.projectocolibri.core.support.AccessPassword;
import org.projectocolibri.core.support.AutorLegal;
import org.projectocolibri.core.support.install.PLATFORMS;
import org.projectocolibri.core.support.printer.PrinterList;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.beans.licencas.LICENCAS;

public class Colibri {
    public static final boolean DEVELOPER_MODE = false;
    public static final SERVERS REMOTE_SERVER = SERVERS.LOCAL;
    public static final MARKETS MARKET_TYPE = MARKETS.INTERNAL;
    public static final VERSIONS VERSION_TYPE = VERSIONS.DESKTOP;
    public static final VersionNumber VERSION_NUMBER = new VersionNumber(Activator.PLUGIN_VERSION);
    public static final AutorLegal AUTOR_LEGAL = new AutorLegal("DeltaFIL", 505636700, "suporte@deltafil.com");
    public static final LanguageBundleMap LANGUAGE_BUNDLE = new Language();
    public static final String PROJECTO_NOME = new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Projecto Colibri", "Colibri Project").toString();
    public static final String PROJECTO_VERSAO = String.valueOf(VERSION_NUMBER.toString(3)) + " " + (Object)((Object)VERSION_TYPE);
    public static final String PROJECTO_TITULO = String.valueOf(PROJECTO_NOME) + " " + PROJECTO_VERSAO;
    public static final String PROJECTO_DEPOSITO = "1419/D/07";
    public static final int PROJECTO_CERTIFICADO = 38;
    public static final PLATFORMS INSTALL_PLATFORM = PLATFORMS.getCurrent();
    public static final PrinterList PRINTER_LIST = PrinterList.getInstance();
    public static final AccessPassword ACCESS_PASSWORD = AccessPassword.getInstance(VERSION_TYPE == VERSIONS.SERVER ? 128 : 4);
    public static final BlowfishPassword PASSWORD_CIPHER = new BlowfishPassword("MIICeAIBADANBgkq");
    public static final EmailAddress CONTROL_EMAIL = new EmailAddress(PREFERENCES.CONTROL_EMAIL.value.getString());
    public static final ServerParameters CONTROL_SERVER = new ServerParameters("mail.xxx.com", 25, ServerParameters.SECURITY.NONE, new PasswordAuthentication("control@xxx.com", ""));
    public static final String IMAGE_EXTENSIONS = "*.ico;*.gif;*.bmp;*.png;*.jpg;*.jpeg";
    public static final int NO_INDEX = -1;
    private static boolean dirty = false;
    private static DebugLogger logger;

    public static void markDirty() {
        dirty = true;
    }

    public static boolean isDirty() {
        return dirty;
    }

    public static DebugLogger logger() {
        return logger;
    }

    static int start(Plugin plugin) {
        Debug.STATUS = false;
        logger = new DebugLogger(plugin);
        System.err.println(SystemUtils.OS_NAME);
        System.err.println(SystemUtils.JAVA_NAME);
        System.err.println(PROJECTO_VERSAO);
        if (SystemUtils.IS_OS_ARCH_64 && !SystemUtils.IS_JAVA_ARCH_64) {
            System.err.println("JAVA ARCH is not optimal!");
        }
        ArrayList<String> languages = new ArrayList<String>();
        ArrayList<String> countries = new ArrayList<String>();
        Serializable[] serializableArray = Locale.getAvailableLocales();
        int n = serializableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = serializableArray[n2];
            if (!locale.getLanguage().isEmpty()) {
                languages.add(locale.getLanguage());
            }
            if (!locale.getCountry().isEmpty()) {
                countries.add(locale.getCountry());
            }
            ++n2;
        }
        System.out.println("AVAILABLE languages: " + languages.size());
        System.out.println("AVAILABLE countries: " + countries.size());
        System.out.println("DEFAULT CHARSET: " + Charset.defaultCharset().name());
        System.out.println("FILE ENCODING: " + System.getProperty("file.encoding"));
        if (!PREFERENCES.INTERNAL_LOCK.value.getBoolean()) {
            try {
                serializableArray = new Class[]{FILES.CONFIG.class, FILES.IMAGES.class, FILES.MESSAGES.class, FILES.DATABASES.class};
                n = serializableArray.length;
                n2 = 0;
                while (n2 < n) {
                    Serializable klass = serializableArray[n2];
                    Class.forName(((Class)klass).getName());
                    ++n2;
                }
                if (VERSION_TYPE == VERSIONS.INTERNAL && MARKET_TYPE == MARKETS.EXTERNAL) {
                    throw new ExceptionInInitializerError("INVALID MARKET TYPE");
                }
                if (VERSION_TYPE == VERSIONS.DESKTOP) {
                    ColibriLicenca.update();
                }
                CERTIFICATES.update((File)FOLDERS.CERTIFICATES.folder);
                BIRTEngineFactory.getInstance().startup();
                return 0;
            }
            catch (Exception e) {
                Colibri.logger().log(DebugLogger.SEVERITY.ERROR, (Throwable)e);
                return 1;
            }
        }
        return 2;
    }

    public static enum FILES {
        LICENCA("colibri", Colibri.MARKET_TYPE.language.suffix),
        COOLBAR("Coolbar", "coolbar"),
        FILTERS("Filter", "filter"),
        LAYOUTS("Layout", "layout"),
        TEMPLATES("Template", "rptdesign");

        public final FileParameters parameters;

        private FILES(String prefix, String suffix) {
            this.parameters = new FileParameters(prefix, suffix, (File)FOLDERS.WORKSPACE.folder);
        }

        public FileParameters getParameters(String prefix) {
            return new FileParameters(CustomFile.normalize((String)prefix), this.parameters.suffix, (File)this.parameters.folder);
        }

        public static enum CONFIG {
            PRINTERS("PrintersConfig.ini", FOLDERS.CONFIG),
            DIACRITICAL("DiacriticalMarks.ini", FOLDERS.CONFIG),
            SWIFT_BANK_CODES("SWIFTBankCodes.ini", FOLDERS.CONFIG),
            DAILY_TIPS("DailyTips.ini", FOLDERS.CONFIG),
            REPORT_EMPTY("Empty.rptdesign", FOLDERS.CONFIG),
            FONTS("fontsConfig.xml", FOLDERS.CONFIG);

            public final String pathname;

            private CONFIG(String filename, FOLDERS folder) {
                CustomFile file = folder.getFile(filename);
                this.pathname = file.toString();
                if (!file.exists()) {
                    throw new ExceptionInInitializerError("FILE NOT FOUND: " + file);
                }
            }
        }

        public static enum DATABASES {
            EMPRESAS(true, "Empresas", "xml"),
            LICENCAS(true, "Licencas", "xml"),
            COLIBRI(false, "colibri", ".h2.db");

            public final FileParameters parameters;

            private DATABASES(boolean singleton, String prefix, String suffix) {
                this.parameters = new FileParameters(prefix, suffix, (File)FOLDERS.DATABASES.folder);
                if (FOLDERS.DATABASES.length == 0) {
                    if (singleton) {
                        DATABASES.move((File)new FileParameters(prefix, suffix, (File)FOLDERS.APPLICATION.folder).toFile());
                    } else {
                        File[] fileArray = FOLDERS.APPLICATION.folder.listFiles(this.parameters.wildcards);
                        int n2 = fileArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            File file = fileArray[n3];
                            DATABASES.move(file);
                            ++n3;
                        }
                    }
                }
            }

            private static void move(File file) {
                if (new CustomFile(file).moveTo((File)FOLDERS.DATABASES.folder, new CopyOption[0])) {
                    System.out.println("MOVED: " + file);
                }
            }
        }

        public static enum IMAGES {
            BANNER_SMALL("banner-small.jpg", FOLDERS.IMAGES),
            BIRT_DEPLOY("deploy.png", FOLDERS.IMAGES_BIRT),
            REPORT_DRAFT("draft.png", FOLDERS.IMAGES_BIRT_BACKGROUND),
            REPORT_DELETED("deleted.png", FOLDERS.IMAGES_BIRT_BACKGROUND),
            REPORT_WATERMARK("watermark.jpg", FOLDERS.IMAGES_BIRT_BACKGROUND);

            public final String pathname;

            private IMAGES(String filename, FOLDERS folder) {
                CustomFile file = folder.getFile(filename);
                this.pathname = file.toString();
                if (!file.exists()) {
                    throw new ExceptionInInitializerError("FILE NOT FOUND: " + file);
                }
            }

            public Image getImage() {
                return ImageManager.getImage((String)this.pathname);
            }
        }

        public static enum MESSAGES {
            ACORDO_UTILIZACAO("Acordo-utilizacao.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_ACTIVA("Licenca-activa.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_EXPIRADA("Licenca-expirada.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_INACTIVA("Licenca-inactiva.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_INEXISTENTE("Licenca-inexistente.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_NIF_EMPRESA("Licenca-nif-empresa.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_PAGAMENTO("Licenca-pagamento.txt", FOLDERS.LANGUAGE_CODE),
            LICENCA_RENOVADA("Licenca-renovada.txt", FOLDERS.LANGUAGE_CODE),
            LIMITE_FACTURACAO("Limite-facturacao.txt", FOLDERS.LANGUAGE_CODE),
            AVISO_CERTIFICACAO("Aviso-certificacao.txt", FOLDERS.LANGUAGE_CODE),
            AVISO_VERSAO_DEMO("Aviso-versao-demo.txt", FOLDERS.LANGUAGE_CODE),
            AVISO_VERSAO_GRATUITA("Aviso-versao-gratuita.txt", FOLDERS.LANGUAGE_CODE),
            INSTALACAO_INACTIVA("Instalacao-inactiva.txt", FOLDERS.LANGUAGE_CODE),
            UPDATES_AUTOMATICOS(SystemUtils.IS_OS_WINDOWS ? "Updates-windows.txt" : "Updates-automaticos.txt", FOLDERS.LANGUAGE_CODE),
            UPDATES_MULTIPOSTO("Updates-multiposto.txt", FOLDERS.LANGUAGE_CODE),
            UPDATES_INSTALADOR("Updates-instalador.txt", FOLDERS.LANGUAGE_CODE),
            BACKUPS_AUTOMATICOS("Backups-automaticos.txt", FOLDERS.LANGUAGE_CODE),
            IMPORTACAO_TODOS_CP("Importacao-todos-cp.txt", FOLDERS.LANGUAGE_CODE),
            ANONIMIZAR_REGISTOS("Anonimizar-registos.txt", FOLDERS.LANGUAGE_CODE),
            ANULACAO_DOCUMENTOS("Anulacao-documentos.txt", FOLDERS.LANGUAGE_CODE),
            SERIES_DOCUMENTAIS("Series-documentais.txt", FOLDERS.LANGUAGE_CODE),
            SERIES_INTEGRACAO("Series-Integracao.txt", FOLDERS.LANGUAGE_CODE),
            ADESAO_WEBSERVICES("Adesao-webservices.txt", FOLDERS.LANGUAGE_CODE),
            REMOTE_UPDATES("Remote-updates.txt", FOLDERS.LANGUAGE_CODE),
            REMOTE_ASSISTANCE("Remote-assistance.txt", FOLDERS.LANGUAGE_CODE);

            public final String filename;
            public final String text;

            private MESSAGES(String filename, FOLDERS folder) {
                this.filename = filename;
                CustomFile file = folder.getFile(filename);
                this.text = new UTF8TextFile((File)file).read();
                if (!file.exists()) {
                    throw new ExceptionInInitializerError("FILE NOT FOUND: " + file);
                }
            }
        }

        public static enum REMOTE {
            UPDATES("updates", "ini", "/download/colibri"),
            CONTROL("control", "ini", "/download/colibri/versao" + Colibri.VERSION_NUMBER.major);

            public final FileParameters parameters;

            private REMOTE(String prefix, String suffix, String foldername) {
                this.parameters = REMOTE_SERVER == SERVERS.DELTAFIL ? new FileParameters(prefix, suffix, foldername) : new FileParameters(prefix, suffix, (File)FOLDERS.WORKSPACE.folder);
            }

            private RemoteFileHandler getHandler(File file) {
                switch (this) {
                    case UPDATES: {
                        return new UpdateFileHandler(file);
                    }
                    case CONTROL: {
                        return new ControlFileHandler(file);
                    }
                }
                return null;
            }

            public void create(File folder) {
                this.getHandler((File)this.parameters.cloneCopy(folder).toFile()).save();
            }

            public RemoteFileHandler getHandler() {
                return this.getHandler((File)this.parameters.toFile());
            }
        }
    }

    public static enum FOLDERS {
        PLUGIN(Activator.pathResolver("/"), new String[0]),
        CERTIFICATES(PLUGIN, "certificates"),
        CONFIG(PLUGIN, "config"),
        LOGOS(PLUGIN, "logos"),
        ICONS(PLUGIN, "icons"),
        ICONS_ETC(ICONS, "etc"),
        ICONS_GOOGLE(ICONS, "google", "16dp", "FILL0", "wght400", "GRAD0", "opsz48"),
        ICONS_FAM(ICONS, "fam"),
        ICONS_FAM_FLAG(ICONS_FAM, "flag"),
        ICONS_FAM_MINI(ICONS_FAM, "mini"),
        IMAGES(PLUGIN, "images"),
        IMAGES_BIRT(IMAGES, "birt"),
        IMAGES_BIRT_BACKGROUND(IMAGES_BIRT, Colibri.MARKET_TYPE.language.name()),
        LANGUAGE(PLUGIN, "language"),
        LANGUAGE_CODE(LANGUAGE, Language.LANGUAGE_CODE),
        POPULATE(PLUGIN, "populate"),
        POPULATE_TABELAS(POPULATE, Colibri.MARKET_TYPE.language.name(), "tabelas"),
        POPULATE_TEMPLATES(POPULATE, Colibri.MARKET_TYPE.language.name(), "templates"),
        APPLICATION(Folder.current((String[])new String[0])),
        WORKSPACE(true, APPLICATION, "workspace"),
        TEMPLATES(VERSION_TYPE == VERSIONS.SERVER ? Folder.temporary((String[])new String[0]) : FOLDERS.WORKSPACE.folder),
        DATABASES(true, APPLICATION, "databases"),
        BACKUPS(true, APPLICATION, "backups");

        public final Folder folder;
        public final int length;

        private FOLDERS(Folder folder) {
            this(false, folder);
        }

        private FOLDERS(FOLDERS folder, String ... more) {
            this(false, folder, more);
        }

        private FOLDERS(String pathname, String ... more) {
            this(false, pathname, more);
        }

        private FOLDERS(boolean create, FOLDERS folder, String ... more) {
            this(create, folder.folder.getPath(), more);
        }

        private FOLDERS(boolean create, String pathname, String ... more) {
            this(create, new Folder(pathname, more));
        }

        private FOLDERS(boolean create, Folder folder) {
            this.folder = folder;
            System.out.println(String.valueOf(this.name()) + ": " + folder);
            if (create) {
                folder.create();
            }
            if (!folder.exists()) {
                throw new ExceptionInInitializerError("FOLDER NOT FOUND: " + (Object)((Object)this));
            }
            this.length = folder.listFiles().length;
        }

        public CustomFile getFile(String ... more) {
            return new CustomFile((File)this.folder, more);
        }
    }

    public static enum FUNCIONALIDADES {
        MULTI_EMPRESA(LICENCAS.PRO, LICENCAS.DEMO),
        BASE_DADOS_REMOTA(LICENCAS.PRO, LICENCAS.DEMO),
        CERTIFICADO_DIGITAL(LICENCAS.PRO, LICENCAS.DEMO),
        AVISOS_FACTURACAO(LICENCAS.PRO, LICENCAS.DEMO),
        FULL_PERMISSIONS(LICENCAS.PRO, LICENCAS.DEMO),
        REPORT_MULTIFORMAT(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.DEMO),
        PAGAMENTOS_MULTIBANCO(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.DEMO),
        WEBSERVICE_DOCUMENTOS(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.DEMO),
        WEBSERVICE_VIES(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.DEMO),
        LICENCA_COMERCIAL(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        IMPRESSAO_DIRECTA(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        CAMPOS_ADICIONAIS(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        REGIME_IVA_CAIXA(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        WEBSERVICE_SERIES(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        INVENTARIO_EXISTENCIAS(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        FACTURACAO_ELECTRONICA(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        COMUNICACAO_ELECTRONICA(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO),
        ACTUALIZACAO_AUTOMATICA(LICENCAS.PRO, LICENCAS.PLUS, LICENCAS.LITE, LICENCAS.DEMO);

        private final Collection<LICENCAS> tipo;

        private FUNCIONALIDADES(LICENCAS ... tipo) {
            this.tipo = Arrays.asList(tipo);
        }

        public boolean contains(LICENCAS tipo) {
            return this.tipo.contains(tipo);
        }
    }

    public static enum ICONS {
        GOOGLE_ACCOUNT_TREE("account_tree", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ADD("add", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARROW_BACK("arrow_back", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARROW_DOWN("arrow_downward", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARROW_FORWARD("arrow_forward", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARROW_UP("arrow_upward", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARTICLE("article", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ARTICLE_SHORTCUT("article_shortcut", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ATTACH_FILE("attach_file", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_BUG_REPORT("bug_report", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CHECK("check", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CIRCLE("circle", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CLOSE("close", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CONSTRUCTION("construction", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CONTENT_CUT("content_cut", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CONTENT_COPY("content_copy", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CONTENT_PASTE("content_paste", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DATABASE("database", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DESCRIPTION("description", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DOWNLOAD("download", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DOWNLOADING("downloading", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DRAFT("draft", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_DROPDOWN("dropdown", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_EDIT_DOCUMENT("edit_document", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_FILE_COPY("file_copy", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_FILE_OPEN("file_open", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_FILTER_ALT("filter_alt", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_FORWARD_TO_INBOX("forward_to_inbox", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_HELP("help", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_INFO("info", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_INSTALL_DESKTOP("install_desktop", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_LIST_ALT("list_alt", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_LOCAL_ATM("local_atm", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_LOCAL_SHIPPING("local_shipping", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_LOGOUT("logout", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_MOP("mop", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_MOVE_UP("move_up", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_PERSON("person", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_PICTURE_AS_PDF("picture_as_pdf", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_PLAY_ARROW("play_arrow", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_POWER_SETTINGS_NEW("power_settings_new", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_PRINT("print", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_REDO("redo", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_REFRESH("refresh", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_RESTART_ALT("restart_alt", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_ROUTER("router", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SAVE("save", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SCAN_DELETE("scan_delete", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SEARCH("search", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SETTINGS("settings", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SETTINGS_BACKUP_RESTORE("settings_backup_restore", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_STOP("stop", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_SUBDIRECTORY_ARROW_RIGHT("subdirectory_arrow_right", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_TOOLBAR("toolbar", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_UNDO("undo", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_UPLOAD("upload", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_CODE_BLOCKS("code_blocks", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        GOOGLE_INSERT_CHART("insert_chart", TYPES.PNG, FOLDERS.ICONS_GOOGLE),
        SYSTRAY_LOGO_16("systray_16", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_16("colibri_16", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_32("colibri_32", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_48("colibri_48", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_64("colibri_64", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_128("colibri_128", TYPES.PNG, FOLDERS.LOGOS),
        COLIBRI_LOGO_256("colibri_256", TYPES.PNG, FOLDERS.LOGOS),
        WINDOW_SHELL(COLIBRI_LOGO_16),
        WINDOW_VIEW(GOOGLE_DRAFT),
        WINDOW_BROWSER(GOOGLE_CIRCLE),
        WINDOW_TREE(GOOGLE_ACCOUNT_TREE),
        WINDOW_INFO(GOOGLE_INFO),
        WINDOW_REPORT(GOOGLE_ATTACH_FILE),
        WINDOW_FILTER(GOOGLE_FILTER_ALT),
        REPORT_FORMAT_PDF(GOOGLE_ARTICLE, COLORS.RED),
        REPORT_FORMAT_WEB(GOOGLE_CODE_BLOCKS, COLORS.ORANGE),
        REPORT_FORMAT_XLS(GOOGLE_INSERT_CHART, COLORS.GREEN),
        STATUSBAR_ERROR("flag_red", TYPES.GIF, FOLDERS.ICONS_FAM_MINI),
        STATUSBAR_ALERT("flag_orange", TYPES.GIF, FOLDERS.ICONS_FAM_MINI),
        STATUSBAR_SUCCESS("flag_green", TYPES.GIF, FOLDERS.ICONS_FAM_MINI),
        COOLBAR_TABELAS(GOOGLE_TOOLBAR),
        COOLBAR_PARAMETROS(GOOGLE_CONSTRUCTION),
        COOLBAR_PROCESSAMENTOS(GOOGLE_SETTINGS),
        COOLBAR_REINICIAR(GOOGLE_POWER_SETTINGS_NEW),
        COOLBAR_SAIR(GOOGLE_LOGOUT),
        COOLBAR_AJUDA(GOOGLE_HELP),
        COOLBAR_ASSISTENCIA(GOOGLE_INSTALL_DESKTOP),
        COOLBAR_ACTUALIZACAO(GOOGLE_DOWNLOADING),
        COOLBAR_DEBUG(GOOGLE_BUG_REPORT, COLORS.RED),
        COOLBAR_DATABASE(GOOGLE_DATABASE),
        COOLBAR_PAGAMENTOS("multibanco-logo", TYPES.PNG, FOLDERS.ICONS_ETC),
        COOLBAR_COMUNICACAO("autoridade-tributaria-logo", TYPES.PNG, FOLDERS.ICONS_ETC),
        TOOLBAR_FORMATO_RELATORIO(GOOGLE_REFRESH),
        TOOLBAR_APLICAR_FILTRO(GOOGLE_FILTER_ALT),
        TOOLBAR_EDITAR_FILTRO(GOOGLE_EDIT_DOCUMENT),
        TOOLBAR_APLICAR_LAYOUT(GOOGLE_CHECK),
        TOOLBAR_GRAVAR_LAYOUT(GOOGLE_SAVE),
        TOOLBAR_ACTUALIZAR(GOOGLE_REFRESH),
        TOOLBAR_PESQUISAR(GOOGLE_SEARCH),
        TOOLBAR_ADICIONAR(GOOGLE_ADD),
        TOOLBAR_ALTERAR(GOOGLE_EDIT_DOCUMENT),
        TOOLBAR_REMOVER(GOOGLE_CLOSE),
        TOOLBAR_IMPORTAR(GOOGLE_UPLOAD),
        TOOLBAR_EXPORTAR(GOOGLE_DOWNLOAD),
        TOOLBAR_LIMPAR(GOOGLE_MOP),
        TOOLBAR_RESET(GOOGLE_RESTART_ALT),
        TOOLBAR_SETA_ESQUERDA(GOOGLE_ARROW_BACK),
        TOOLBAR_SETA_DIREITA(GOOGLE_ARROW_FORWARD),
        TOOLBAR_SETA_CIMA(GOOGLE_ARROW_UP),
        TOOLBAR_SETA_BAIXO(GOOGLE_ARROW_DOWN),
        TOOLBAR_ENTIDADES(GOOGLE_SEARCH),
        TOOLBAR_TRAJECTO(GOOGLE_LOCAL_SHIPPING),
        TOOLBAR_VIES(GOOGLE_ROUTER),
        ACTION_NOVO(GOOGLE_DRAFT, COLORS.GREEN),
        ACTION_EDITAR(GOOGLE_EDIT_DOCUMENT, COLORS.GREEN),
        ACTION_ANULAR(GOOGLE_SCAN_DELETE, COLORS.GREEN),
        ACTION_DUPLICAR(GOOGLE_FILE_COPY, COLORS.GREEN),
        ACTION_GRAVAR(GOOGLE_SAVE, COLORS.GREEN),
        ACTION_APAGAR(GOOGLE_CLOSE, COLORS.RED),
        ACTION_PROCESSAR(GOOGLE_SETTINGS_BACKUP_RESTORE),
        ACTION_COMUNICAR(GOOGLE_ROUTER, COLORS.GREEN),
        ACTION_COPIAR(GOOGLE_CONTENT_COPY, COLORS.GREEN),
        ACTION_COLAR(GOOGLE_CONTENT_PASTE, COLORS.GREEN),
        ACTION_IMPORTAR(GOOGLE_UPLOAD, COLORS.GREEN),
        ACTION_EXPORTAR(GOOGLE_DOWNLOAD, COLORS.GREEN),
        ACTION_EDITAR_TEMPLATE(GOOGLE_EDIT_DOCUMENT, COLORS.GREEN),
        ACTION_EDITAR_FILTRO(GOOGLE_FILTER_ALT, COLORS.GREEN),
        ACTION_REPORT(GOOGLE_PICTURE_AS_PDF, COLORS.RED),
        ACTION_IMPRIMIR(GOOGLE_PRINT, COLORS.GREEN),
        ACTION_ENVIAR_EMAIL(GOOGLE_FORWARD_TO_INBOX, COLORS.GREEN),
        ACTION_ADICIONAR(GOOGLE_ADD, COLORS.GREEN),
        ACTION_INSERIR(GOOGLE_SUBDIRECTORY_ARROW_RIGHT),
        ACTION_REMOVER(GOOGLE_CLOSE, COLORS.RED);

        public final FileParameters parameters;
        public final BufferedImage image;
        public final COLORS color;
        private final ConcurrentHashMap<Integer, BufferedImage> cache = new ConcurrentHashMap();

        private ICONS(ICONS icon) {
            this(icon.parameters, icon.image, icon.color);
        }

        private ICONS(ICONS icon, COLORS color) {
            this(icon, new Folder((File)icon.parameters.folder, new String[]{color.value}), color);
        }

        private ICONS(ICONS icon, Folder folder, COLORS color) {
            this(icon.parameters.cloneCopy((File)folder), color);
        }

        private ICONS(String name, TYPES type, FOLDERS folder) {
            this(new FileParameters(name, type.name, (File)folder.folder), COLORS.BLACK);
        }

        private ICONS(FileParameters parameters, COLORS color) {
            this(parameters, ImageHandler.createImage((String)parameters.toString()), color);
        }

        private ICONS(FileParameters parameters, BufferedImage image, COLORS color) {
            this.parameters = parameters;
            this.image = image;
            this.color = color;
            if (!parameters.exists()) {
                throw new ExceptionInInitializerError("FILE NOT FOUND: " + parameters);
            }
        }

        public BufferedImage getImage(int size) {
            BufferedImage image = this.cache.get(size);
            if (image == null) {
                image = new ImageHandler(this.image).resize(size, new BufferedImageOp[0]);
                this.cache.put(size, image);
            }
            return image;
        }

        public Image getImage() {
            return ImageManager.getImage((BufferedImage)this.image);
        }

        public static String getPath(Paises pais) {
            return new FileParameters(pais.getCodigo(), TYPES.PNG.name, (File)FOLDERS.ICONS_FAM_FLAG.folder).toString();
        }

        public static enum COLORS {
            BLACK("000000"),
            ORANGE("D79E68"),
            GREEN("00AB55"),
            RED("DA0E00");

            public final String value;

            private COLORS(String value) {
                this.value = value;
            }
        }

        public static enum TYPES {
            PNG("png"),
            GIF("gif");

            public final String name;

            private TYPES(String name) {
                this.name = name;
            }
        }
    }

    public static enum MARKETS {
        INTERNAL(CheckVatHandler.COUNTRIES.PT, LICENCAS.LANGUAGES.pt),
        EXTERNAL(CheckVatHandler.COUNTRIES.ES, LICENCAS.LANGUAGES.en);

        public final CheckVatHandler.COUNTRIES country;
        public final LICENCAS.LANGUAGES language;

        private MARKETS(CheckVatHandler.COUNTRIES country, LICENCAS.LANGUAGES language) {
            this.country = country;
            this.language = language;
        }
    }

    public static enum PREFERENCES {
        CONTROL_EMAIL("control@projectocolibri.com"),
        LANGUAGE_CODE(Colibri.MARKET_TYPE.language.name()),
        LOGIN_USER(Utilizadores.USERS.ADMIN.user),
        INSTALLER_NAME(""),
        INSTALLER_VERSION(VERSION_NUMBER.toString()),
        INSTALLER_DATE(0),
        DEFAULTS_LOCK(false),
        INTERNAL_LOCK(false);

        public static final int DECIMALS_SCALE = 6;
        public final IPreferenceValue value;

        static {
            PREFERENCES.DEFAULTS_LOCK.value.setToDefault();
        }

        private PREFERENCES(Object defaultValue) {
            this.value = Activator.PLUGIN_STORE.getValue(this.name(), defaultValue);
        }
    }

    public static enum VERSIONS {
        INTERNAL(true, Utilizadores.PASSWORD_TYPE.DESKTOP),
        SERVER(true, Utilizadores.PASSWORD_TYPE.WEB),
        PLUGIN(true, Utilizadores.PASSWORD_TYPE.DESKTOP),
        DESKTOP(false, Utilizadores.PASSWORD_TYPE.DESKTOP);

        public final boolean silent;
        public final Utilizadores.PASSWORD_TYPE password;

        private VERSIONS(boolean silent, Utilizadores.PASSWORD_TYPE password) {
            this.silent = silent;
            this.password = password;
        }

        public void ensure(VERSIONS version) throws Exception {
            if (this != version) {
                throw new Exception("VERSION TYPE should be " + (Object)((Object)version));
            }
        }
    }

    public static enum WEBPAGES {
        PRODUTO(MARKET_TYPE == MARKETS.INTERNAL ? "http://www.projectocolibri.com" : "http://www.colibriproject.net"),
        DESCONTINUADO(WEBPAGES.PRODUTO.url.path(new String[]{"colibri", MARKET_TYPE == MARKETS.INTERNAL ? "descontinuado" : "discontinued"})),
        INFORMACAO(WEBPAGES.PRODUTO.url.path(new String[]{"colibri", String.valueOf(Colibri.VERSION_NUMBER.major)})),
        INSTALACAO(WEBPAGES.PRODUTO.url.path(new String[]{MARKET_TYPE == MARKETS.INTERNAL ? "instalacao" : "install"})),
        REGISTO(WEBPAGES.PRODUTO.url.path(new String[]{MARKET_TYPE == MARKETS.INTERNAL ? "registo" : "register"})),
        AJUDA(WEBPAGES.PRODUTO.url.path(new String[]{MARKET_TYPE == MARKETS.INTERNAL ? "centroajuda" : "forums"}));

        public final HttpURLHandler url;
        public final String name;

        private WEBPAGES(String name) {
            this.url = new HttpURLHandler(name, new String[0]);
            if (!this.url.isValid()) {
                throw new ExceptionInInitializerError("INVALID URL: " + (Object)((Object)this));
            }
            this.name = this.url.getName();
        }

        public boolean browse() {
            if (!SystemUtils.IS_OS_LINUX) {
                try {
                    return Program.launch((String)this.url.path(new String[0]));
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            return this.url.browse();
        }
    }
}

