/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.mediator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.mediator.IMediator;
import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.mediator.IMediatorState;
import org.eclipse.birt.report.designer.core.mediator.IMediatorStateConverter;
import org.eclipse.birt.report.designer.core.mediator.impl.MediatorRequestImpl;
import org.eclipse.birt.report.designer.core.mediator.impl.MediatorStateImpl;

public class MediatorImpl
implements IMediator {
    private static final List<IMediatorColleague> globalListeners = new LinkedList<IMediatorColleague>();
    private final List<IMediatorColleague> listeners = new LinkedList<IMediatorColleague>();
    private List<MediatorStateImpl> stack = new ArrayList<MediatorStateImpl>();
    private int stackPointer = 0;
    private MediatorStateImpl currentState = new MediatorStateImpl();
    private boolean isDispatching = false;
    private IMediatorStateConverter converter;

    public static void addGlobalColleague(IMediatorColleague colleague) {
        if (!globalListeners.contains(colleague)) {
            globalListeners.add(colleague);
        }
    }

    public static void removeGlobalColleague(IMediatorColleague colleague) {
        globalListeners.remove(colleague);
    }

    public void addColleague(IMediatorColleague colleague) {
        if (!this.listeners.contains(colleague)) {
            this.listeners.add(colleague);
        }
    }

    public void removeColleague(IMediatorColleague colleague) {
        this.listeners.remove(colleague);
    }

    public void notifyRequest(IMediatorRequest request) {
        IMediatorColleague colleague;
        if (this.isDispatching) {
            return;
        }
        this.isDispatching = true;
        if (request.isSticky()) {
            this.currentState.copyFrom(this.convertRequestToState(request));
        }
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            colleague = this.listeners.get(i);
            if (colleague.isInterested(request)) {
                colleague.performRequest(request);
            }
            ++i;
        }
        size = globalListeners.size();
        i = 0;
        while (i < size) {
            colleague = globalListeners.get(i);
            if (colleague.isInterested(request)) {
                colleague.performRequest(request);
            }
            ++i;
        }
        this.isDispatching = false;
    }

    public IMediatorState getState() {
        return this.currentState;
    }

    public void pushState() {
        try {
            if (this.stack.size() > this.stackPointer) {
                MediatorStateImpl s = this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add((MediatorStateImpl)this.currentState.clone());
            }
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void popState() {
        --this.stackPointer;
        if (this.stackPointer != 0) {
            this.restoreState(this.stack.get(this.stackPointer));
        }
        if (this.stackPointer == 0) {
            this.stack.clear();
        }
    }

    public void restoreState() {
        this.restoreState(this.stack.get(this.stackPointer - 1));
    }

    private void restoreState(MediatorStateImpl s) {
        this.currentState.copyFrom(s);
        IMediatorRequest request = this.convertStateToRequest(s);
        this.notifyRequest(request);
    }

    private IMediatorState convertRequestToState(IMediatorRequest request) {
        MediatorStateImpl state = new MediatorStateImpl();
        state.setType(request.getType());
        state.setSource(request.getSource());
        state.setData(request.getData());
        Map<?, ?> extras = request.getExtras();
        if (extras != null && !extras.isEmpty()) {
            state.setExtras(new HashMap(extras));
        }
        return state;
    }

    private IMediatorRequest convertStateToRequest(IMediatorState state) {
        if (this.converter != null) {
            return this.converter.convertStateToRequest(state);
        }
        return new MediatorRequestImpl(state);
    }

    public void dispose() {
        this.currentState = null;
        this.listeners.clear();
        this.stackPointer = 0;
        this.stack = null;
    }

    public void setStateConverter(IMediatorStateConverter converter) {
        this.converter = converter;
    }

    public IMediatorStateConverter getStateConverter() {
        return this.converter;
    }
}

