/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.scale;

import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.script.api.scale.IScale;
import org.eclipse.birt.chart.script.internal.scale.CategoryScaleImpl;
import org.eclipse.birt.chart.script.internal.scale.LinearScaleImpl;
import org.eclipse.birt.chart.script.internal.scale.LogarithmicScaleImpl;
import org.eclipse.birt.chart.script.internal.scale.TimeScaleImpl;

public abstract class ScaleImpl
implements IScale {
    protected Axis axis;
    protected Scale scale;

    protected ScaleImpl(Axis axis) {
        this.axis = axis;
        this.scale = axis.getScale();
    }

    public boolean isAuto() {
        return !this.scale.isSetStep() && !this.scale.isSetStepNumber();
    }

    public boolean isCategory() {
        return this.axis.isCategoryAxis();
    }

    public void setAuto() {
        this.scale.unsetStep();
        this.scale.unsetStepNumber();
    }

    public void setCategory(boolean category) {
        this.axis.setCategoryAxis(category);
    }

    public static IScale createScale(Axis axis) {
        if (axis.isCategoryAxis()) {
            return new CategoryScaleImpl(axis);
        }
        switch (axis.getType().getValue()) {
            case 0: {
                return new LinearScaleImpl(axis);
            }
            case 3: {
                return new TimeScaleImpl(axis);
            }
            case 1: {
                return new LogarithmicScaleImpl(axis);
            }
        }
        return new CategoryScaleImpl(axis);
    }
}

