/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.empresas.tabs.geral;

import java.util.Calendar;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomCTabItem;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.nebula.widgets.formattedtext.DateFormatter;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.language.Language;
import org.projectocolibri.ui.login.empresas.EmpresasShell;
import org.projectocolibri.ui.login.empresas.tabs.geral.EmpresasTab1Validator;
import org.projectocolibri.xml.beans.StringConverter;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class EmpresasTab1
extends CustomCTabItem
implements IFieldRules {
    private Label label_nome;
    private Text text_nome;
    private Label label_observacoes;
    private Text text_observacoes;
    private Label label_datacriacao;
    private Text text_datacriacao;
    private final EmpresasShell shell;

    public EmpresasShell getShell() {
        return this.shell;
    }

    public EmpresasTab1(CTabFolder tabFolder, EmpresasShell shell) {
        super(tabFolder, 0);
        this.shell = shell;
        this.setText(LABELS.login_empresas_tab_gerais.toString());
        this.setControl((Control)this.createContents());
        this.registerValidator();
        this.updateTarget();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        TraverseSupport traverseSupport = new TraverseSupport(true);
        this.label_nome = new Label(composite, 0);
        this.label_nome.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_nome.setText(LABELS.login_empresas_nome.toString());
        this.text_nome = new Text(composite, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 450;
        this.text_nome.setLayoutData((Object)gridData);
        traverseSupport.add((Control)this.text_nome);
        this.label_observacoes = new Label(composite, 0);
        this.label_observacoes.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_observacoes.setText(LABELS.login_empresas_obs.toString());
        this.text_observacoes = new Text(composite, 2048);
        this.text_observacoes.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        traverseSupport.add((Control)this.text_observacoes);
        this.label_datacriacao = new Label(composite, 0);
        this.label_datacriacao.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_datacriacao.setText(LABELS.login_empresas_data.toString());
        this.text_datacriacao = new Text(composite, 2048);
        this.text_datacriacao.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new FormattedText(this.text_datacriacao).setFormatter((ITextFormatter)new DateFormatter(TimeDateUtils.DEFAULT_DATE_PATTERN, Language.LOCALE));
        traverseSupport.add((Control)this.text_datacriacao);
        return composite;
    }

    private void registerValidator() {
        EmpresasTab1Validator validator = new EmpresasTab1Validator(this);
        validator.register(LABELS.login_empresas_nome.name(), this.label_nome, (Control)this.text_nome, new FieldFormat(FieldFormat.TYPES.STRING, 60, new char[0]), 8);
        validator.register(LABELS.login_empresas_obs.name(), this.label_observacoes, (Control)this.text_observacoes, new FieldFormat(FieldFormat.TYPES.STRING, 60, new char[0]), 0);
        validator.register(LABELS.login_empresas_data.name(), this.label_datacriacao, (Control)this.text_datacriacao, 8);
        this.shell.getValidationManager().register(this.getText(), (IValidator)validator);
    }

    private void updateTarget() {
        try {
            EmpresaDocument.Empresa empresa = this.shell.getEmpresa();
            this.text_nome.setText(StringConverter.trim((String)empresa.getNome()));
            this.text_observacoes.setText(StringConverter.trim((String)empresa.getObs()));
            this.text_datacriacao.setText(StringConverter.toString((Calendar)empresa.getData()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EmpresaDocument.Empresa updateModel(EmpresaDocument.Empresa empresa) {
        try {
            empresa.setNome(StringConverter.trim((String)this.text_nome.getText()));
            empresa.setObs(StringConverter.trim((String)this.text_observacoes.getText()));
            empresa.setData(StringConverter.toCalendar((String)this.text_datacriacao.getText()));
            this.shell.getTab_database().updateModel(empresa.getDbcolibri());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return empresa;
    }
}

