/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.empresas.tabs.database;

import java.io.File;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomCTabItem;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DRIVERS;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.empresas.EmpresasShell;
import org.projectocolibri.ui.login.empresas.tabs.database.EmpresasTab2Validator;
import org.projectocolibri.ui.login.widgets.ColibriTextButton;
import org.projectocolibri.xml.beans.StringConverter;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class EmpresasTab2
extends CustomCTabItem
implements IFieldRules {
    private Label label_driver;
    private Combo combo_driver;
    private Label label_host;
    private Text text_host;
    private Label label_database;
    private Text text_database;
    private Label label_properties;
    private Text text_properties;
    private Label label_utilizador;
    private Text text_utilizador;
    private Label label_password;
    private Text text_password;
    private final EmpresasShell shell;
    public final CustomAction databaseSearchAction = new CustomAction(){

        public void run() {
            File file = new FileImport((Shell)EmpresasTab2.this.shell, new String[]{Colibri.FILES.DATABASES.COLIBRI.parameters.wildcards}).filePicker(Colibri.FOLDERS.DATABASES.folder, null);
            if (file != null) {
                String database = StringUtils.removeAll((String)file.getAbsolutePath(), (String)Colibri.FILES.DATABASES.COLIBRI.parameters.suffix);
                EmpresasTab2.this.text_database.setText(database);
            }
        }
    };

    public EmpresasShell getShell() {
        return this.shell;
    }

    public EmpresasTab2(CTabFolder tabFolder, EmpresasShell shell) {
        super(tabFolder, 0);
        this.shell = shell;
        this.setText(LABELS.login_empresas_tab_database.toString());
        this.setControl((Control)this.createContents());
        this.registerValidator();
        this.updateTarget();
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        TraverseSupport traverseSupport = new TraverseSupport(true);
        this.label_driver = new Label(composite, 0);
        this.label_driver.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_driver.setText(LABELS.login_empresas_database_driver.toString());
        this.combo_driver = new Combo(composite, 8);
        this.combo_driver.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.combo_driver.setItems(DRIVERS.NAMES);
        traverseSupport.add((Control)this.combo_driver);
        this.label_host = new Label(composite, 0);
        this.label_host.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_host.setText(LABELS.login_empresas_database_host.toString());
        this.text_host = new Text(composite, 2048);
        this.text_host.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        traverseSupport.add((Control)this.text_host);
        this.label_database = new Label(composite, 0);
        this.label_database.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_database.setText(LABELS.login_empresas_database_database.toString());
        this.text_database = new Text(composite, 2048);
        this.text_database.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        traverseSupport.add((Control)this.text_database);
        new ColibriTextButton(composite, LABELS.botao_procurar.toString()).setSelectionAction((IAction)this.databaseSearchAction);
        this.label_properties = new Label(composite, 0);
        this.label_properties.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_properties.setText(LABELS.login_empresas_database_properties.toString());
        this.text_properties = new Text(composite, 2048);
        this.text_properties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        traverseSupport.add((Control)this.text_properties);
        this.label_utilizador = new Label(composite, 0);
        this.label_utilizador.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_utilizador.setText(LABELS.login_empresas_database_utilizador.toString());
        this.text_utilizador = new Text(composite, 2048);
        this.text_utilizador.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        traverseSupport.add((Control)this.text_utilizador);
        this.label_password = new Label(composite, 0);
        this.label_password.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_password.setText(LABELS.login_empresas_database_password.toString());
        this.text_password = new Text(composite, 0x400800);
        this.text_password.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        traverseSupport.add((Control)this.text_password);
        return composite;
    }

    private void registerValidator() {
        EmpresasTab2Validator validator = new EmpresasTab2Validator(this);
        validator.register(LABELS.login_empresas_database_driver.name(), this.label_driver, (Control)this.combo_driver, 4);
        validator.register(LABELS.login_empresas_database_host.name(), this.label_host, (Control)this.text_host, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        validator.register(LABELS.login_empresas_database_database.name(), this.label_database, (Control)this.text_database, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        validator.register(LABELS.login_empresas_database_properties.name(), this.label_properties, (Control)this.text_properties, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        validator.register(LABELS.login_empresas_database_utilizador.name(), this.label_utilizador, (Control)this.text_utilizador, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 8);
        validator.register(LABELS.login_empresas_database_password.name(), this.label_password, (Control)this.text_password, new FieldFormat(FieldFormat.TYPES.STRING, 255, new char[0]), 0);
        this.shell.getValidationManager().register(this.getText(), (IValidator)validator);
    }

    private void updateTarget() {
        EmpresaDocument.Empresa.Dbcolibri dbcolibri = this.shell.getEmpresa().getDbcolibri();
        if (dbcolibri != null) {
            try {
                this.combo_driver.select(DRIVERS.valueOf((String)dbcolibri.getDriver()).ordinal());
                this.text_host.setText(StringConverter.trim((String)dbcolibri.getHost()));
                this.text_database.setText(StringConverter.trim((String)dbcolibri.getDatabase()));
                this.text_properties.setText(StringConverter.trim((String)dbcolibri.getProperties()));
                this.text_utilizador.setText(StringConverter.trim((String)dbcolibri.getUtilizador()));
                this.text_password.setText(StringConverter.trim((String)(dbcolibri.getPassword().isEmpty() ? "" : Colibri.PASSWORD_CIPHER.decode(dbcolibri.getPassword()))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateModel(EmpresaDocument.Empresa.Dbcolibri dbcolibri) {
        try {
            dbcolibri.setDriver(StringConverter.trim((String)this.combo_driver.getText()));
            dbcolibri.setHost(StringConverter.trim((String)this.text_host.getText()));
            dbcolibri.setDatabase(StringConverter.trim((String)this.text_database.getText()));
            dbcolibri.setProperties(StringConverter.trim((String)this.text_properties.getText()));
            dbcolibri.setUtilizador(StringConverter.trim((String)this.text_utilizador.getText()));
            dbcolibri.setPassword(StringConverter.trim((String)(this.text_password.getText().isEmpty() ? "" : Colibri.PASSWORD_CIPHER.encode(this.text_password.getText()))));
            this.shell.getTab_backups().updateModel(dbcolibri.getBackups() == null ? dbcolibri.addNewBackups() : dbcolibri.getBackups());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

