/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.ui.login.empresas;

import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.swt.graphics.ColorManager;
import org.dma.eclipse.swt.input.validation.IValidationManager;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.ValidationManager;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.swt.widgets.CustomShell;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.ui.login.empresas.EmpresasShellValidator;
import org.projectocolibri.ui.login.empresas.tabs.backups.EmpresasTab3;
import org.projectocolibri.ui.login.empresas.tabs.database.EmpresasTab2;
import org.projectocolibri.ui.login.empresas.tabs.geral.EmpresasTab1;
import org.projectocolibri.ui.login.shell.tabs.empresas.LoginTab1Container;
import org.projectocolibri.ui.login.widgets.ColibriTextButton;
import org.projectocolibri.xml.beans.empresas.EmpresaContainer;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class EmpresasShell
extends CustomShell
implements IFieldRules {
    private final IValidationManager validationManager = new ValidationManager(){

        public void postError(String message) {
            Debug.err((String)message);
        }
    };
    private EmpresasTab1 tab_geral;
    private EmpresasTab2 tab_database;
    private EmpresasTab3 tab_backups;
    private final LoginTab1Container tableContainer;
    private final boolean edited;
    public final CustomAction executarBackupAction = new CustomAction(){

        public void run() {
            try {
                DatabaseParameters parameters = EmpresasShell.this.getParameters();
                parameters.executeBackup();
                InformationDialog.open((String)LABELS.info_database_backupefectuado.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorDialog.open((String)LABELS.erro_database_backupfalhado.toString(), (MessageList)new MessageList((Throwable)e));
            }
        }
    };
    public final CustomAction testarLigacaoAction = new CustomAction(){

        public void run() {
            try {
                DatabaseParameters parameters = EmpresasShell.this.getParameters();
                parameters.checkConnection();
                InformationDialog.open((String)LABELS.info_database_ligacaoefectuada.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorDialog.open((String)LABELS.erro_database_ligacaofalhada.toString(), (MessageList)new MessageList((Throwable)e));
            }
        }
    };
    public final CustomAction gravarRegistoAction = new CustomAction(){

        public void run() {
            if (!EmpresasShell.this.validationManager.hasError()) {
                EmpresasShell.this.tab_geral.updateModel(EmpresasShell.this.getEmpresa());
                MessageList error = EmpresasShell.this.tableContainer.insertObject();
                if (!ErrorDialog.open((MessageList)error)) {
                    EmpresasShell.this.dispose();
                }
            }
        }
    };

    public EmpresasTab1 getTab_geral() {
        return this.tab_geral;
    }

    public EmpresasTab2 getTab_database() {
        return this.tab_database;
    }

    public EmpresasTab3 getTab_backups() {
        return this.tab_backups;
    }

    public IValidationManager getValidationManager() {
        return this.validationManager;
    }

    public LoginTab1Container getTableContainer() {
        return this.tableContainer;
    }

    public ColibriLicenca getLicenca() {
        return this.tableContainer.getLicenca();
    }

    public EmpresaDocument.Empresa getEmpresa() {
        return this.tableContainer.getEmpresa();
    }

    public boolean getEdited() {
        return this.edited;
    }

    public EmpresasShell(Shell parent, LoginTab1Container tableContainer, boolean edited) {
        super(parent, 32864);
        this.tableContainer = tableContainer;
        this.edited = edited;
        this.setText(LABELS.login_empresas_window.toString());
        this.setImage(Colibri.ICONS.WINDOW_SHELL.getImage());
        this.setGridLayout();
        this.createTabs();
        this.createButtons();
        this.registerValidator();
        this.pack();
        this.setCenteredLocation();
    }

    public void dispose() {
        super.dispose();
    }

    private void createTabs() {
        CTabFolder tabFolder = new CTabFolder((Composite)this, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.getParent().getSize().x;
        tabFolder.setLayoutData((Object)gridData);
        tabFolder.pack();
        tabFolder.setBorderVisible(true);
        tabFolder.setSimple(false);
        tabFolder.setSelectionBackground(ColorManager.getColor((int)19));
        this.tab_geral = new EmpresasTab1(tabFolder, this);
        this.tab_database = new EmpresasTab2(tabFolder, this);
        this.tab_backups = new EmpresasTab3(tabFolder, this);
    }

    private void createButtons() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        new ColibriTextButton(composite, LABELS.botao_backup.toString()).setSelectionAction((IAction)this.executarBackupAction);
        new ColibriTextButton(composite, LABELS.botao_testar.toString()).setSelectionAction((IAction)this.testarLigacaoAction);
        new ColibriTextButton(composite, LABELS.botao_gravar.toString()).setSelectionAction((IAction)this.gravarRegistoAction);
        new ColibriTextButton(composite, LABELS.botao_sair.key()).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                EmpresasShell.this.dispose();
            }
        });
    }

    private void registerValidator() {
        EmpresasShellValidator validator = new EmpresasShellValidator(this);
        this.validationManager.register(this.getText(), (IValidator)validator);
    }

    public DatabaseParameters getParameters() {
        EmpresaDocument.Empresa empresa = new EmpresaContainer((EmpresaDocument.Empresa)this.getEmpresa()).xml;
        return new DatabaseParameters(this.tab_geral.updateModel(empresa));
    }
}

