/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.impl.CubeMeasureUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;

public class CubeMeasureExpressionProvider
extends CubeExpressionProvider {
    private TabularMeasureHandle handle = null;
    private DataSetHandle dataSetHandle = null;
    private ExpressionFilter filter = null;
    private boolean isDerivedMeasure;

    public boolean isDerivedMeasure() {
        return this.isDerivedMeasure;
    }

    public void setDerivedMeasure(boolean isDerivedMeasure) {
        this.isDerivedMeasure = isDerivedMeasure;
        this.clearFilters();
        this.addFilterToProvider((DesignElementHandle)this.handle);
    }

    public CubeMeasureExpressionProvider(TabularMeasureHandle handle, boolean isDerivedMeasure) {
        super((DesignElementHandle)handle);
        this.isDerivedMeasure = isDerivedMeasure;
        this.handle = handle;
        this.clearFilters();
        if (isDerivedMeasure) {
            this.dataSetHandle = null;
        } else {
            DesignElementHandle parent = handle.getContainer().getContainer();
            if (parent instanceof TabularCubeHandle) {
                this.dataSetHandle = ((TabularCubeHandle)parent).getDataSet();
            }
        }
        this.addFilterToProvider((DesignElementHandle)handle);
    }

    protected void addFilterToProvider(DesignElementHandle handle) {
        this.filter = new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                if (CubeMeasureExpressionProvider.this.isDerivedMeasure) {
                    if ("Category".equals(parentElement) && ExpressionProvider.DATASETS.equals(element)) {
                        return false;
                    }
                } else {
                    if ("Category".equals(parentElement) && ExpressionProvider.CURRENT_CUBE.equals(element)) {
                        return false;
                    }
                    if ("Category".equals(parentElement) && "Measure".equals(element)) {
                        return false;
                    }
                }
                if (CURRENT_CUBE.equals(parentElement) && element instanceof PropertyHandle) {
                    return ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups");
                }
                if (parentElement instanceof MeasureGroupHandle) {
                    if (!CubeMeasureExpressionProvider.this.isDerivedMeasure()) {
                        return true;
                    }
                    if (!(CubeMeasureExpressionProvider.this.elementHandle instanceof MeasureHandle)) {
                        return true;
                    }
                    CubeHandle cubeHandle = (CubeHandle)((MeasureGroupHandle)parentElement).getContainer();
                    List measureHnadles = new ArrayList();
                    try {
                        measureHnadles = CubeMeasureUtil.getIndependentReferences((CubeHandle)cubeHandle, (String)CubeMeasureExpressionProvider.this.elementHandle.getName());
                    }
                    catch (BirtException birtException) {
                        return true;
                    }
                    return measureHnadles.contains(element);
                }
                return true;
            }
        };
        this.addFilter(this.filter);
    }

    protected List getCategoryList() {
        List categoryList = super.getCategoryList();
        if (this.isDerivedMeasure) {
            categoryList.add(CURRENT_CUBE);
        }
        return categoryList;
    }

    public Object[] getChildren(Object parent) {
        Object[] children = super.getChildren(parent);
        return children;
    }
}

