/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view.groups.familias;

import java.util.ArrayList;
import java.util.Collection;
import org.dma.eclipse.jface.CustomAction;
import org.dma.java.util.Debug;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.rcp.pos.workbench.view.groups.familias.FamiliaButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.familias.FamiliasList;

public abstract class FamiliasGroup
extends Group {
    private static final int FIXED_BUTTONS = 2;
    private final FamiliasList familias = new FamiliasList();
    private final Collection<FamiliaButton> buttons = new ArrayList<FamiliaButton>();

    protected void checkSubclass() {
    }

    public abstract void selection(Familias var1);

    public FamiliasList getFamilias() {
        return this.familias;
    }

    public FamiliasGroup(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = FamiliaButton.SIZE.spacing;
        layout.verticalSpacing = FamiliaButton.SIZE.spacing;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, false));
    }

    public void dispose() {
        this.disposeButtons();
        this.familias.dispose();
        super.dispose();
    }

    public void disposeButtons() {
        for (FamiliaButton element : this.buttons) {
            element.dispose();
        }
        this.buttons.clear();
    }

    public void reset() {
        this.familias.reset();
        this.createButtons();
    }

    public void resize() {
        int numColumns = (this.getClientArea().width + FamiliaButton.SIZE.spacing) / (FamiliaButton.SIZE.width + FamiliaButton.SIZE.spacing);
        GridLayout layout = (GridLayout)this.getLayout();
        layout.numColumns = numColumns = Math.max(1, numColumns);
        this.familias.setCount(numColumns - 2);
        this.createButtons();
    }

    private void createButtons() {
        ArrayList<FamiliaButton> col = new ArrayList<FamiliaButton>();
        this.setRedraw(false);
        this.disposeButtons();
        try {
            this.familias.load();
            FamiliaButton button = new FamiliaButton(this);
            col.add(button);
            button.setImage(Colibri.ICONS.TOOLBAR_SETA_ESQUERDA);
            button.setEnabled(this.familias.hasPrevious());
            button.setSelectionAction((IAction)new CustomAction(){

                public void run() {
                    FamiliasGroup.this.familias.previous();
                    FamiliasGroup.this.createButtons();
                }
            });
            int count = this.familias.getCount();
            int i = this.familias.getIndex();
            while (i < this.familias.size() && count > 0) {
                Debug.out((Object)i);
                Familias familia = (Familias)this.familias.get(i);
                button = new FamiliaButton(this);
                col.add(button);
                button.setText(familia.getDescricao());
                button.setToolTipText(familia.getDescricao());
                button.setData(i);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FamiliaButton button = (FamiliaButton)e.widget;
                        int index = (Integer)button.getData();
                        FamiliasGroup.this.selection((Familias)FamiliasGroup.this.familias.get(index));
                    }
                });
                --count;
                ++i;
            }
            button = new FamiliaButton(this);
            col.add(button);
            button.setImage(Colibri.ICONS.TOOLBAR_SETA_DIREITA);
            button.setEnabled(this.familias.hasNext());
            button.setSelectionAction((IAction)new CustomAction(){

                public void run() {
                    FamiliasGroup.this.familias.next();
                    FamiliasGroup.this.createButtons();
                }
            });
            this.setText("Familias (" + this.familias.size() + ")");
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setRedraw(true);
        this.buttons.addAll(col);
    }
}

