/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view.groups.artigos;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dma.java.util.PagedList;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public class ArtigosList
extends PagedList<Artigos> {
    private static final long serialVersionUID = 1L;
    private final Map<String, Collection<Artigos>> cache = new HashMap<String, Collection<Artigos>>();

    public void dispose() {
        this.clear();
        this.cache.clear();
    }

    public void reset() {
        this.clear();
        this.setIndex(0);
    }

    private QueryDefinition createQuery(Familias familia) {
        ORDERING ordering = ORDERING.get();
        QueryDefinition query = new QueryDefinition(TABLES.artigos, new QueryOrdering(ordering.direction, new TableFieldKey[]{new TableFieldKey(new FIELDS[]{ordering.field})})).addFetchplan(new TableFieldKey[]{new TableFieldKey(new FIELDS[]{FIELDS.artigos_codigo}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_descricao}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_descricao2}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_imagem}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_precoupv}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_codigoiva, FIELDS.codigosiva_taxa}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_precos, FIELDS.artigosprecos_precoiva}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_precos, FIELDS.artigosprecos_unidademedida, FIELDS.unidadesmedida_codigo}), new TableFieldKey(new FIELDS[]{FIELDS.artigos_precos, FIELDS.artigosprecos_unidademedida, FIELDS.unidadesmedida_grandeza})});
        query.addRule(new FilterMapRule(new FIELDS[]{FIELDS.artigos_familia, FIELDS.familias_codigo}).equal(familia.getCodigo())).addRule(new FilterMapRule(new FIELDS[]{FIELDS.artigos_botao}).equal(Integer.valueOf(1)));
        if (ColibriDatabase.getManager().getParametrospos().getTipoartigos() == 1) {
            query.addRule(new FilterMapRule(new FIELDS[]{FIELDS.artigos_imagem}).notEqual(Integer.valueOf(0)));
        }
        return query;
    }

    public void load(Familias familia) {
        Collection col = this.cache.get(familia.getCodigo());
        if (col == null) {
            col = ColibriDatabase.getManager().getArtigosCollection(this.createQuery(familia));
            this.cache.put(familia.getCodigo(), col);
        }
        this.clear();
        this.addAll(col);
    }

    private static enum ORDERING {
        CODIGO(FIELDS.artigos_codigo, QueryOrdering.DIRECTION.ASCENDING),
        DESCRICAO(FIELDS.artigos_descricao, QueryOrdering.DIRECTION.ASCENDING),
        ENTRADAS(FIELDS.artigos_entradas, QueryOrdering.DIRECTION.DESCENDING),
        SAIDAS(FIELDS.artigos_saidas, QueryOrdering.DIRECTION.DESCENDING),
        STOCK(FIELDS.artigos_stockreal, QueryOrdering.DIRECTION.DESCENDING);

        public final FIELDS field;
        public final QueryOrdering.DIRECTION direction;

        private ORDERING(FIELDS field, QueryOrdering.DIRECTION direction) {
            this.field = field;
            this.direction = direction;
        }

        public static ORDERING get() {
            switch (ColibriDatabase.getManager().getParametrospos().getOrdenacaoartigos()) {
                case 0: {
                    return CODIGO;
                }
                case 1: {
                    return DESCRICAO;
                }
                case 2: {
                    return ENTRADAS;
                }
                case 3: {
                    return SAIDAS;
                }
                case 4: {
                    return STOCK;
                }
            }
            return CODIGO;
        }
    }
}

