/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view.groups.artigos;

import java.util.ArrayList;
import java.util.Collection;
import org.dma.eclipse.jface.CustomAction;
import org.dma.java.util.Debug;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigoButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigoImageButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigosList;

public abstract class ArtigosGroup
extends Group {
    private static final int FIXED_BUTTONS = 2;
    private final ArtigosList artigos = new ArtigosList();
    private final Collection<ArtigoButton> buttons = new ArrayList<ArtigoButton>();

    protected void checkSubclass() {
    }

    public abstract void selection(ArtigoImageButton var1);

    public ArtigosList getArtigos() {
        return this.artigos;
    }

    public ArtigosGroup(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = ArtigoButton.SIZE.spacing;
        layout.verticalSpacing = ArtigoButton.SIZE.spacing;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    public void dispose() {
        this.disposeButtons();
        this.artigos.dispose();
        super.dispose();
    }

    public void reset() {
        this.reset(ColibriDatabase.getManager().getParametrospos().getFamilias().isEmpty() ? null : ColibriDatabase.getManager().getParametrospos().getFamilias(0));
    }

    public void reset(Familias familia) {
        this.artigos.reset();
        this.createButtons(familia);
    }

    public int getNumRows() {
        return (this.getClientArea().height + ArtigoButton.SIZE.spacing) / (ArtigoButton.SIZE.height + ArtigoButton.SIZE.spacing);
    }

    public void resize() {
        int numColumns = (this.getClientArea().width + ArtigoButton.SIZE.spacing) / (ArtigoButton.SIZE.width + ArtigoButton.SIZE.spacing);
        GridLayout layout = (GridLayout)this.getLayout();
        layout.numColumns = Math.max(1, numColumns);
        this.artigos.setCount(numColumns * this.getNumRows() - 2);
    }

    private void disposeButtons() {
        for (ArtigoButton element : this.buttons) {
            element.dispose();
        }
        this.buttons.clear();
    }

    private void createButtons(final Familias familia) {
        ArrayList<ArtigoButton> col = new ArrayList<ArtigoButton>();
        this.setRedraw(false);
        this.disposeButtons();
        if (familia != null) {
            try {
                this.artigos.load(familia);
                ArtigoButton button = new ArtigoButton(this);
                col.add(button);
                button.setImage(Colibri.ICONS.TOOLBAR_SETA_ESQUERDA);
                button.setEnabled(this.artigos.hasPrevious());
                button.setSelectionAction((IAction)new CustomAction(){

                    public void run() {
                        ArtigosGroup.this.artigos.previous();
                        ArtigosGroup.this.createButtons(familia);
                    }
                });
                int count = this.artigos.getCount();
                int i = this.artigos.getIndex();
                while (i < this.artigos.size() && count > 0) {
                    Debug.out((Object)i);
                    button = new ArtigoImageButton(this, (Artigos)this.artigos.get(i));
                    col.add(button);
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ArtigoImageButton button = (ArtigoImageButton)e.widget;
                            ArtigosGroup.this.selection(button);
                        }
                    });
                    --count;
                    ++i;
                }
                button = new ArtigoButton(this);
                col.add(button);
                button.setImage(Colibri.ICONS.TOOLBAR_SETA_DIREITA);
                button.setEnabled(this.artigos.hasNext());
                button.setSelectionAction((IAction)new CustomAction(){

                    public void run() {
                        ArtigosGroup.this.artigos.next();
                        ArtigosGroup.this.createButtons(familia);
                    }
                });
                this.setText(String.valueOf(familia.getDescricao()) + " (" + this.artigos.size() + ")");
                this.layout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ArtigoButton element : col) {
            element.setImage();
        }
        this.setRedraw(true);
        this.buttons.addAll(col);
    }
}

