/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench.view;

import java.util.ArrayList;
import java.util.Collection;
import org.dma.java.util.ClipboardManager;
import org.dma.java.util.Debug;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigoImageButton;
import org.projectocolibri.rcp.pos.workbench.view.groups.artigos.ArtigosGroup;
import org.projectocolibri.rcp.pos.workbench.view.groups.familias.FamiliasGroup;
import org.projectocolibri.rcp.pos.workbench.view.groups.talao.TalaoGroup;

public class POSView
extends ColibriViewPart<ViewParameters> {
    public static final String ID = POSView.class.getCanonicalName();
    private Composite composite_left;
    private Composite composite_right;
    private FamiliasGroup group_familias;
    private ArtigosGroup group_artigos;
    private TalaoGroup group_talao;
    private final Collection<Artigos> selection = new ArrayList<Artigos>();

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void createControl() {
        this.setIcon();
        this.setTitle();
        this.createActions(this);
        this.createContents(this.getParent());
    }

    @Override
    public void setFocus() {
        this.group_talao.setFocus();
    }

    private void layout() {
        this.group_familias.layout();
        this.group_artigos.layout();
        this.composite_left.layout();
        this.composite_right.layout();
    }

    public void reset() {
        this.selection.clear();
        this.group_familias.reset();
        this.group_artigos.reset();
        this.group_talao.reset();
        this.layout();
    }

    private void createActions(POSView view) {
        this.getActions().add(new CommandAction(Utilizadores.COMMANDS.ColarRegisto){

            public void run() {
                Collection clipboard = ClipboardManager.getClipboard(Artigos.class);
                for (Artigos artigo : clipboard) {
                    POSView.this.group_talao.insert(artigo.getCodigo());
                }
            }

            @Override
            public boolean canRun() {
                return true;
            }

            @Override
            public boolean isValid() {
                return true;
            }
        });
    }

    private void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.composite_left = this.createCompositeLeft(composite);
        this.composite_right = this.createCompositeRight(composite);
    }

    private Composite createCompositeLeft(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.group_familias = new FamiliasGroup(composite){

            @Override
            public void selection(Familias familia) {
                POSView.this.group_artigos.reset(familia);
                POSView.this.group_talao.setFocus();
            }
        };
        this.group_artigos = new ArtigosGroup(composite){

            @Override
            public void selection(ArtigoImageButton button) {
                POSView.this.group_talao.insert(button.getArtigo(), button.getPreco());
                POSView.this.selection.add(button.getArtigo());
            }
        };
        this.group_artigos.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Debug.err((String)"Resize");
                POSView.this.group_familias.resize();
                POSView.this.group_artigos.resize();
                POSView.this.layout();
            }
        });
        return composite;
    }

    private Composite createCompositeRight(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.group_talao = new TalaoGroup(composite, this);
        this.group_talao.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Debug.err((String)"Paint");
                POSView.this.group_talao.removeListener(9, this);
                POSView.this.reset();
            }
        });
        return composite;
    }

    @Override
    public void initialize(ViewParameters parameters) {
        super.initialize(parameters);
    }

    @Override
    public void setIcon() {
    }

    @Override
    public void setTitle() {
        this.setPartName(ColibriDatabase.getManager().getParametrospos().getTipodocumento().getDescricao());
    }

    @Override
    public void executeOnPartActivated() {
        Debug.err((String)"executeOnPartActivated");
        super.executeOnPartActivated();
    }

    @Override
    public void executeOnPartDeactivated() {
        Debug.err((String)"executeOnPartDeactivated");
        ClipboardManager.copyToClipboard(this.selection);
        super.executeOnPartDeactivated();
    }

    @Override
    public void executeOnPartBroughtToTop() {
        Debug.err((String)"executeOnPartBroughtToTop");
        super.executeOnPartBroughtToTop();
    }

    @Override
    public void executeOnPartOpened() {
        Debug.err((String)"executeOnPartOpened");
        super.executeOnPartOpened();
    }

    @Override
    public void executeOnPartClosed() {
        Debug.err((String)"executeOnPartClosed");
        this.group_talao.dispose();
        this.group_artigos.dispose();
        this.group_familias.dispose();
        super.executeOnPartClosed();
    }

    @Override
    public boolean isRestorable() {
        return true;
    }
}

