/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.pos.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IWorkbenchWindow;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriPageLayout;
import org.projectocolibri.rcp.colibri.workbench.IColibriPerspective;
import org.projectocolibri.rcp.colibri.workbench.actions.CleanPerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.actions.ClosePerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.actions.ResetPerspectiveAction;
import org.projectocolibri.rcp.colibri.workbench.support.bars.coolbar.ColibriCoolBarItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.menubar.ColibriMenuBarItem;
import org.projectocolibri.rcp.pos.workbench.actions.OpenParametrosPreferenceAction;
import org.projectocolibri.rcp.pos.workbench.view.POSView;
import org.projectocolibri.xml.beans.licencas.LICENCAS;

public class POSPerspective
extends ColibriPageLayout
implements IColibriPerspective {
    public static final String ID = POSPerspective.class.getCanonicalName();

    public POSPerspective() {
        super(ID);
    }

    @Override
    public void createInitialLayout(IPageLayout layout) {
        layout.setFixed(false);
        layout.setEditorAreaVisible(false);
        layout.addView(POSView.ID, 1, 0.7f, layout.getEditorArea());
        layout.getViewLayout(POSView.ID).setCloseable(false);
        super.createInitialLayout(layout);
    }

    private Collection<IAction> createFileActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new OpenParametrosPreferenceAction(window));
        actions.add((IAction)new ClosePerspectiveAction(ID));
        return actions;
    }

    private Collection<IAction> createWorkspaceActions(IWorkbenchWindow window) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.add((IAction)new CleanPerspectiveAction());
        actions.add((IAction)new ResetPerspectiveAction());
        return actions;
    }

    @Override
    public Collection<ColibriMenuBarItem> createMenuBar(IWorkbenchWindow window) {
        return Arrays.asList(new ColibriMenuBarItem(LABELS.menubar_ficheiro.toString(), this.createFileActions(window)), new ColibriMenuBarItem(LABELS.menubar_workspace.toString(), this.createWorkspaceActions(window)));
    }

    @Override
    public Collection<ColibriCoolBarItem> createCoolBar(IWorkbenchWindow window) {
        return Arrays.asList(new ColibriCoolBarItem(ID, this.createFileActions(window)));
    }

    @Override
    public boolean saveOnClose() {
        return ColibriDatabase.getManager().getLicenca().hasModulo(new LICENCAS.MODULOS[]{LICENCAS.MODULOS.POS});
    }

    @Override
    public String getId() {
        return ID;
    }
}

