/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.tree.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.widgets.CustomImageDescriptor;
import org.dma.eclipse.ui.UIHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.model.Utilizadoresicones;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.InterfaceVARS;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.documentos.ArtigosDocumentosView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.documentos.emissao.ArtigosEmissaoView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.ficheiro.ArtigosFicheiroView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.documentos.EntidadesDocumentosView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.documentos.emissao.EntidadesEmissaoView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.ficheiro.EntidadesFicheiroView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.movimentos.EntidadesMovimentosView;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.ITreeNode;

public class TreeTerminalNode
extends ArrayList<ITreeNode>
implements ITreeNode {
    private static final long serialVersionUID = 1L;
    private final TreeGroupModel group;
    private final TreeBranchModel branch;
    private final Utilizadoresicones icone;

    public TreeTerminalNode(TreeGroupModel group, TreeBranchModel branch) {
        this.group = group;
        this.branch = branch;
        this.icone = ColibriDatabase.getManager().getUtilizadoresicones(branch.group, branch.branch, branch.tipoentidade, branch.tipodocumento);
    }

    private ViewParameters getParameters() {
        switch (this.group.group) {
            case ARTIGOS: {
                switch (this.branch.branch) {
                    case FICHEIRO: {
                        return new ViewParameters(ArtigosFicheiroView.ID);
                    }
                    case MOVIMENTOS: {
                        return new ViewParameters(ArtigosMovimentosView.ID);
                    }
                    case DOCUMENTOS: {
                        return new ViewParameters(ArtigosDocumentosView.ID);
                    }
                    case DOCUMENTOSTIPOS: {
                        return new ViewParameters(RCPcolibri.PREFERENCES.OPEN_DOCUMENTS_VIEW.value.getBoolean() ? ArtigosDocumentosView.ID : ArtigosEmissaoView.ID, this.branch.tipodocumento);
                    }
                }
                break;
            }
            case ENTIDADES: {
                switch (this.branch.branch) {
                    case FICHEIRO: {
                        return new ViewParameters(EntidadesFicheiroView.ID, this.branch.tipoentidade);
                    }
                    case MOVIMENTOS: {
                        return new ViewParameters(EntidadesMovimentosView.ID, this.branch.tipoentidade);
                    }
                    case DOCUMENTOS: {
                        return new ViewParameters(EntidadesDocumentosView.ID, this.branch.tipoentidade);
                    }
                    case DOCUMENTOSTIPOS: {
                        return new ViewParameters(RCPcolibri.PREFERENCES.OPEN_DOCUMENTS_VIEW.value.getBoolean() ? EntidadesDocumentosView.ID : EntidadesEmissaoView.ID, this.branch.tipodocumento);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getGroup() {
        return this.group.toString();
    }

    @Override
    public String getLabel() {
        return this.branch.label();
    }

    @Override
    public BufferedImage getImage() {
        return this.icone.getIconeToImage(InterfaceVARS.ICON_COOLBAR_SIZE);
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public IAction getAction() {
        ColibriViewAction action = new ColibriViewAction(this.getParameters());
        action.setImageDescriptor((ImageDescriptor)new CustomImageDescriptor(this.getImage()));
        action.setToolTipText(this.getLabel());
        action.setText(this.getLabel());
        return action;
    }

    @Override
    public boolean showToolBar() {
        return false;
    }

    @Override
    public boolean hideToolBar() {
        return false;
    }

    @Override
    public int countVisibleIcons() {
        return 0;
    }

    @Override
    public boolean isIconVisible() {
        return this.icone != null && this.icone.getVisivel() != false;
    }

    @Override
    public boolean showIcon() {
        if (!this.isIconVisible()) {
            this.icone.setVisivel(Boolean.valueOf(true));
            ColibriDatabase.getManager().storeUtilizadoresicones(this.icone);
            return true;
        }
        return false;
    }

    @Override
    public boolean hideIcon() {
        if (this.isIconVisible()) {
            this.icone.setVisivel(Boolean.valueOf(false));
            ColibriDatabase.getManager().storeUtilizadoresicones(this.icone);
            return true;
        }
        return false;
    }

    @Override
    public boolean changeIcon() {
        File file = new FileImport(UIHelper.getWorkbenchShell(), new String[]{"*.ico;*.gif;*.bmp;*.png;*.jpg;*.jpeg"}).filePicker();
        if (file != null) {
            this.icone.setIcone(file);
            ColibriDatabase.getManager().storeUtilizadoresicones(this.icone);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "group=" + this.group + "," + "label=" + this.getLabel();
    }
}

