/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.tree;

import java.util.ArrayList;
import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.mapper.tree.TreeList;
import org.projectocolibri.rcp.colibri.workbench.support.views.IColibriMenuTree;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeContentProvider;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeCoolBarMap;
import org.projectocolibri.rcp.colibri.workbench.views.tree.TreeLabelProvider;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.ITreeNode;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.TreeNode;
import org.projectocolibri.rcp.colibri.workbench.views.tree.model.TreeTerminalNode;

public class TreeContainer
extends ArrayList<ITreeNode>
implements IColibriMenuTree {
    private static final long serialVersionUID = 1L;
    private final TreeViewer viewer;

    public TreeContainer(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        viewer.setInput((Object)this);
    }

    @Override
    public void build() {
        this.clear();
        Debug.out((String)"BUILDING");
        for (TreeGroupModel group : new TreeList(ColibriDatabase.getManager())) {
            TreeNode node = new TreeNode(group);
            for (TreeBranchModel branch : group) {
                node.add(new TreeTerminalNode(group, branch));
            }
            this.add(node);
        }
        this.expand();
        this.viewer.refresh();
    }

    @Override
    public void expand() {
        this.viewer.expandAll();
    }

    @Override
    public void collapse() {
        this.viewer.collapseAll();
    }

    @Override
    public boolean isExpanded() {
        return this.viewer.getTree().getItem(0).getExpanded();
    }

    @Override
    public TreeCoolBarMap getCoolBarMap() {
        return new TreeCoolBarMap(this);
    }
}

