/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.filters.swt;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManager;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterFieldMap;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilterOperandMap;

public class SWTFilterMap
extends FilterMap {
    private static final long serialVersionUID = 1L;
    private final Map<TableFieldKey, SWTFilterFieldMap> map = new LinkedHashMap<TableFieldKey, SWTFilterFieldMap>();

    public SWTFilterMap(TABLES table) {
        super(table);
    }

    public void clear() {
        this.map.clear();
        super.clear();
    }

    public void put(TableFieldKey fieldKey, SWTFilterFieldMap fieldMap) {
        this.map.put(fieldKey, fieldMap);
    }

    public FilterMap toMap() {
        super.clear();
        for (TableFieldKey fieldKey : this.map.keySet()) {
            FilterMapRule rule = new FilterMapRule(fieldKey);
            FIELDS field = this.table.map.get((TableFieldKey)fieldKey).field;
            SWTFilterFieldMap fieldMap = this.map.get(fieldKey);
            int index = 0;
            for (SWTFilterOperandMap SWTOperand : fieldMap) {
                if (index > 0) {
                    rule.add(OPERATORS.LOGICAL.get((int)fieldMap.getLogicalOperators(index - 1).getSelectionIndex()));
                }
                OPERATORS.MATH mathOperator = OPERATORS.MATH.GROUPS.find((FIELDS.TYPES)field.type).operators[SWTOperand.getOperator().getSelectionIndex()];
                String value = SWTOperand.getValue();
                switch (SWTOperand.getType()) {
                    case VALUE: {
                        block5 : switch (field.combo) {
                            case NONE: {
                                switch (field.type) {
                                    default: {
                                        break block5;
                                    }
                                    case TIME: {
                                        value = SWTOperand.getFormatter().getValue() == null ? null : TimeDateUtils.getTimeFormatted((Date)((Date)SWTOperand.getFormatter().getValue()));
                                        break block5;
                                    }
                                    case DATE: {
                                        value = SWTOperand.getFormatter().getValue() == null ? null : TimeDateUtils.getDateFormatted((Date)((Date)SWTOperand.getFormatter().getValue()));
                                        break block5;
                                    }
                                    case DECIMAL: 
                                    case INTEGER: 
                                    case STRING: 
                                    case LONGSTRING: 
                                }
                                Combo control = (Text)SWTOperand.getControl();
                                value = control.getText();
                                break;
                            }
                            case ARRAY: {
                                Combo control = (Combo)SWTOperand.getControl();
                                if (control.getSelectionIndex() > 0) {
                                    switch (field.type) {
                                        default: {
                                            value = String.valueOf(control.getSelectionIndex() - 1);
                                            break block5;
                                        }
                                        case BOOLEAN: {
                                            value = OPERANDS.VALUES.BOOLEAN.values()[control.getSelectionIndex() - 1].value;
                                            break block5;
                                        }
                                        case BINARY: 
                                    }
                                    value = OPERANDS.VALUES.BINARY.values()[control.getSelectionIndex() - 1].value;
                                    break;
                                }
                                value = null;
                                break;
                            }
                            case TABLE: {
                                Combo control = (Combo)SWTOperand.getControl();
                                IDatabaseModel model = ComboManager.getSelectedObject(control);
                                try {
                                    Method method = model.getClass().getDeclaredMethod(IDatabaseModel.METHODS.GET.name(field), new Class[0]);
                                    value = (String)method.invoke((Object)model, new Object[0]);
                                    break;
                                }
                                catch (Exception exception) {}
                            }
                        }
                        rule.add(StringUtils.isEmpty((String)value) ? new FilterOperandMap(mathOperator) : new FilterOperandMap(mathOperator, value));
                        break;
                    }
                    case VAR: 
                    case FIELD: {
                        rule.add(new FilterOperandMap(mathOperator, value, SWTOperand.getType()));
                    }
                }
                ++index;
            }
            super.put((Object)fieldKey, (Object)rule);
        }
        return this;
    }

    public String toReadable(ILabelFormatter formatter) {
        return this.toMap().toReadable(formatter);
    }

    public String toText() {
        this.toMap();
        return super.toText();
    }

    public String toString() {
        this.toMap();
        return super.toString();
    }
}

