/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.filters;

import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.IViewTableContainer;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.documentos.ArtigosDocumentosView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.ficheiro.ArtigosFicheiroView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.documentos.EntidadesDocumentosView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.ficheiro.EntidadesFicheiroView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.movimentos.EntidadesMovimentosView;
import org.projectocolibri.rcp.colibri.workbench.views.filters.FilterValidator;
import org.projectocolibri.rcp.colibri.workbench.views.filters.swt.SWTFilter;

public class FilterView
extends ColibriViewPart<ViewParameters> {
    public static final String ID = FilterView.class.getCanonicalName();
    private final FilterValidator validator = new FilterValidator(this);
    private ScrolledComposite sc;
    private SWTFilter SWTfilter;
    public final CommandAction novoRegistoAction = new CommandAction(Utilizadores.COMMANDS.NovoRegisto){

        public void run() {
            FilterView.this.initialize(new ViewParameters(ID, ((ViewParameters)FilterView.this.getParameters()).getTipoentidade(), ColibriDatabase.getManager().loadPesquisas(((ViewParameters)FilterView.this.getParameters()).getPesquisa().getCodigo())));
        }

        @Override
        public boolean canRun() {
            return QuestionDialog.open((String)LABELS.operacao_registo_novo.toString());
        }

        @Override
        public boolean isValid() {
            return !FilterView.this.SWTfilter.hasError();
        }
    };
    public final CommandAction gravarRegistoAction = new CommandAction(Utilizadores.COMMANDS.GravarRegisto){

        public void run() {
            ((ViewParameters)FilterView.this.getParameters()).getPesquisa().setFiltro(FilterView.this.SWTfilter.toMap());
            ColibriDatabase.getManager().storeUtilizadoresfiltros(((ViewParameters)FilterView.this.getParameters()).getPesquisa());
        }

        @Override
        public boolean isValid() {
            return !FilterView.this.SWTfilter.hasError();
        }
    };
    public final CommandAction pesquisarRegistoAction = new CommandAction(Utilizadores.COMMANDS.PesquisarRegisto){

        public void run() {
            ColibriViewAction action = ((ViewParameters)FilterView.this.getParameters()).getTipoentidade() == null ? new ColibriViewAction(new ViewParameters(VIEWS.get((Pesquisas)((ViewParameters)FilterView.this.getParameters()).getPesquisa()).id)) : new ColibriViewAction(new ViewParameters(VIEWS.get((Pesquisas)((ViewParameters)FilterView.this.getParameters()).getPesquisa()).id, ((ViewParameters)FilterView.this.getParameters()).getTipoentidade()));
            IViewTableContainer view = (IViewTableContainer)action.run(false);
            view.getTableContainer().updateTable(FilterView.this.SWTfilter.toMap());
        }

        @Override
        public boolean isValid() {
            return !FilterView.this.SWTfilter.hasError();
        }
    };

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void createControl() {
        this.getActions().addToolItem(this.novoRegistoAction).addToolItem(this.gravarRegistoAction).addToolItem(this.pesquisarRegistoAction);
        this.sc = this.createComposite();
    }

    private ScrolledComposite createComposite() {
        ScrolledComposite sc = new ScrolledComposite(this.getParent(), 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getVerticalBar().setIncrement(20);
        sc.setSize(this.getParent().getSize());
        return sc;
    }

    @Override
    public void initialize(ViewParameters parameters) {
        super.initialize(parameters);
        this.setContentDescription(((ViewParameters)this.getParameters()).getPesquisa().toString());
        if (this.SWTfilter != null) {
            this.SWTfilter.dispose();
        }
        this.SWTfilter = new SWTFilter(this.sc, ((ViewParameters)this.getParameters()).getPesquisa().getFiltroToMap());
        this.validator.validateButtons();
    }

    @Override
    public boolean isInitialized() {
        return this.getParameters() != null;
    }

    @Override
    public void setIcon() {
        this.setTitleImage(Colibri.ICONS.WINDOW_FILTER);
    }

    @Override
    public void setTitle() {
        this.setPartName(((ViewParameters)this.getParameters()).getTipoentidade() == null ? VIEWS.get((Pesquisas)((ViewParameters)this.getParameters()).getPesquisa()).label.toString() : VIEWS.get((Pesquisas)((ViewParameters)this.getParameters()).getPesquisa()).label.format(new String[]{((ViewParameters)this.getParameters()).getTipoentidade().getDescricao()}));
    }

    @Override
    public void setFocus() {
        if (this.SWTfilter != null) {
            this.SWTfilter.setFocus();
        }
    }

    @Override
    public void executeOnPartClosed() {
        this.SWTfilter.dispose();
    }

    private static enum VIEWS {
        ARTIGOS_FICHEIRO(ArtigosFicheiroView.ID, TABLES.artigos, LABELS.menutree_artigos_ficheiro),
        ARTIGOS_DOCUMENTOS(ArtigosDocumentosView.ID, TABLES.artigosdocumentos, LABELS.menutree_artigos_documentos),
        ARTIGOS_MOVIMENTOS(ArtigosMovimentosView.ID, TABLES.artigosmovimentos, LABELS.menutree_artigos_movimentos),
        ENTIDADES_FICHEIRO(EntidadesFicheiroView.ID, TABLES.entidades, LABELS.menutree_entidades_ficheiro),
        ENTIDADES_DOCUMENTOS(EntidadesDocumentosView.ID, TABLES.entidadesdocumentos, LABELS.menutree_entidades_documentos),
        ENTIDADES_MOVIMENTOS(EntidadesMovimentosView.ID, TABLES.entidadesmovimentos, LABELS.menutree_entidades_movimentos);

        public final String id;
        public final TABLES table;
        public final LABELS label;

        private VIEWS(String id, TABLES table, LABELS label) {
            this.id = id;
            this.table = table;
            this.label = label;
        }

        public static VIEWS get(Pesquisas pesquisa) {
            TABLES table = pesquisa.table();
            VIEWS[] vIEWSArray = VIEWS.values();
            int n = vIEWSArray.length;
            int n2 = 0;
            while (n2 < n) {
                VIEWS value = vIEWSArray[n2];
                if (table == value.table) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }
}

