/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.entidades.ficheiro.registo.tabs.geral;

import java.awt.Desktop;
import java.net.URI;
import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.core.bindings.ValueBindingDefinition;
import org.dma.eclipse.core.bindings.converters.CustomConverter;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.message.ConfirmationDialog;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.swt.input.support.TraverseSupport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.services.vies.CheckVatResult;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.google.GoogleMapsServices;
import org.projectocolibri.api.services.google.GoogleServicesClient;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.InterfaceVARS;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManager;
import org.projectocolibri.rcp.colibri.workbench.support.converters.CodigopostalToString;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriLabelButton;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTabItem;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.ficheiro.registo.EntidadesRegistoView;
import org.projectocolibri.rcp.colibri.workbench.views.entidades.ficheiro.registo.tabs.geral.EntidadesRegistoTab1Validator;

public class EntidadesRegistoTab1
extends ColibriTabItem {
    private ColibriLabelButton button_morada;
    private Text text_morada;
    private Label label_codigopostal;
    private Text text_codigopostal;
    private Text text_localidade;
    private Label label_pais;
    private Combo combo_pais;
    private ComboViewer comboViewer_pais;
    private ColibriLabelButton button_nif;
    private Text text_nif;
    private Label label_zona;
    private Text text_zona;
    private Label label_grupo;
    private Combo combo_grupo;
    private ComboViewer comboViewer_grupo;
    private Label label_familia;
    private Combo combo_familia;
    private ComboViewer comboViewer_familia;
    private final BindingSupport bindingSupport = new BindingSupport();
    private final EntidadesRegistoView view;

    public EntidadesRegistoView getView() {
        return this.view;
    }

    public EntidadesRegistoTab1(final EntidadesRegistoView view) {
        super(view.getTabFolder());
        this.view = view;
        this.setText(LABELS.entidades_tab_geral.toString());
        this.setControl((Control)this.createContents());
        this.registerCombos();
        this.registerBindings();
        this.registerValidator();
        this.setSelectionAction((IAction)new CustomAction(){

            public void run() {
                Debug.err((String)"SELECTION");
                int index = view.getTab_moradas().getTableContainer().getSelectionIndex();
                if (index < 0) {
                    return;
                }
                EntidadesRegistoTab1.this.unregisterBindings();
                EntidadesRegistoTab1.this.registerBindings(index);
            }
        });
    }

    @Override
    public void dispose() {
        this.unregisterValidator();
        this.unregisterBindings();
        this.unregisterCombos();
        super.dispose();
    }

    @Override
    public void reset() {
    }

    private Composite createContents() {
        Composite composite = new Composite((Composite)this.getParent(), 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(4));
        TraverseSupport traverseSupport = new TraverseSupport(RCPcolibri.PREFERENCES.TRAVERSE_KEYPAD_ENTER.value.getBoolean());
        this.button_morada = new ColibriLabelButton(composite, LABELS.entidades_morada_button);
        this.button_morada.setEnabled(ColibriDatabase.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.FULL_PERMISSIONS));
        this.button_morada.setLayoutData(new GridData(131072, 0x1000000, false, false));
        this.button_morada.setImage(Colibri.ICONS.TOOLBAR_TRAJECTO);
        this.button_morada.setSelectionAction((IAction)new CustomAction(){

            public void run() {
                GoogleMapsServices maps = new GoogleMapsServices(new GoogleServicesClient());
                if (maps.isValid()) {
                    try {
                        URI uri = new URI(maps.query(((ViewParameters)EntidadesRegistoTab1.this.view.getParameters()).getEntidade()));
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e) {
                        ErrorDialog.open((String)LABELS.info_operacao_falhada.toString(), (MessageList)new MessageList((Throwable)e));
                    }
                }
            }
        });
        this.text_morada = new Text(composite, 2050);
        GridData gridData = new GridData(450, InterfaceVARS.TEXT_HEIGHT_LARGE);
        gridData.horizontalSpan = 3;
        this.text_morada.setLayoutData((Object)gridData);
        this.text_morada.setToolTipText(LABELS.entidades_morada.tooltip());
        traverseSupport.add((Control)this.text_morada);
        this.view.getFocusSupport().add((Control)this.text_morada);
        this.label_codigopostal = new Label(composite, 0);
        this.label_codigopostal.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_codigopostal.setText(LABELS.entidades_codigopostal.toString());
        this.text_codigopostal = new Text(composite, 2048);
        this.text_codigopostal.setLayoutData((Object)new GridData(150, -1));
        traverseSupport.add((Control)this.text_codigopostal);
        this.view.getFocusSupport().add((Control)this.text_codigopostal);
        this.text_localidade = new Text(composite, 2048);
        gridData = new GridData(250, -1);
        gridData.horizontalSpan = 2;
        this.text_localidade.setLayoutData((Object)gridData);
        traverseSupport.add((Control)this.text_localidade);
        this.view.getFocusSupport().add((Control)this.text_localidade);
        this.label_pais = new Label(composite, 0);
        this.label_pais.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_pais.setText(LABELS.entidades_pais.toString());
        this.combo_pais = new Combo(composite, 2048);
        gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.combo_pais.setLayoutData((Object)gridData);
        this.combo_pais.setVisibleItemCount(20);
        this.comboViewer_pais = new ComboViewer(this.combo_pais);
        traverseSupport.add((Control)this.combo_pais);
        this.view.getFocusSupport().add((Control)this.combo_pais);
        this.button_nif = new ColibriLabelButton(composite, LABELS.entidades_nif_button);
        this.button_nif.setEnabled(ColibriDatabase.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.WEBSERVICE_VIES));
        this.button_nif.setLayoutData(new GridData(131072, 0x1000000, false, false));
        this.button_nif.setImage(Colibri.ICONS.TOOLBAR_VIES);
        this.button_nif.setSelectionAction((IAction)new CustomAction(){

            public void run() {
                Entidades entidade = ((ViewParameters)EntidadesRegistoTab1.this.view.getParameters()).getEntidade();
                try {
                    CheckVatResult result = entidade.checkNif();
                    if (!result.isValid()) {
                        InformationDialog.open((String)LABELS.info_operacao_nula.toString());
                    } else if (ConfirmationDialog.open((String)result.getName(), (String)result.getAddress().toString())) {
                        entidade.setVatResult(result);
                    }
                }
                catch (Exception e) {
                    ErrorDialog.open((String)LABELS.info_operacao_falhada.toString(), (MessageList)new MessageList((Throwable)e));
                }
            }
        });
        this.text_nif = new Text(composite, 2048);
        gridData = new GridData(250, -1);
        gridData.horizontalSpan = 3;
        this.text_nif.setLayoutData((Object)gridData);
        traverseSupport.add((Control)this.text_nif);
        this.view.getFocusSupport().add((Control)this.text_nif);
        this.label_zona = new Label(composite, 0);
        this.label_zona.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_zona.setText(LABELS.entidades_zona.toString());
        this.text_zona = new Text(composite, 2048);
        gridData = new GridData(250, -1);
        gridData.horizontalSpan = 3;
        this.text_zona.setLayoutData((Object)gridData);
        traverseSupport.add((Control)this.text_zona);
        this.view.getFocusSupport().add((Control)this.text_zona);
        this.label_grupo = new Label(composite, 0);
        this.label_grupo.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_grupo.setText(LABELS.entidades_grupo.toString());
        this.combo_grupo = new Combo(composite, 2048);
        gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.combo_grupo.setLayoutData((Object)gridData);
        this.combo_grupo.setVisibleItemCount(20);
        this.comboViewer_grupo = new ComboViewer(this.combo_grupo);
        traverseSupport.add((Control)this.combo_grupo);
        this.view.getFocusSupport().add((Control)this.combo_grupo);
        this.label_familia = new Label(composite, 0);
        this.label_familia.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.label_familia.setText(LABELS.entidades_familia.toString());
        this.combo_familia = new Combo(composite, 2048);
        gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.combo_familia.setLayoutData((Object)gridData);
        this.combo_familia.setVisibleItemCount(20);
        this.comboViewer_familia = new ComboViewer(this.combo_familia);
        traverseSupport.add((Control)this.combo_familia);
        this.view.getFocusSupport().add((Control)this.combo_familia);
        return composite;
    }

    private void registerCombos() {
        ComboManager.register(TABLES.paises, this.comboViewer_pais);
        ComboManager.register(TABLES.grupos, 1, this.comboViewer_grupo);
        ComboManager.register(TABLES.familias, 1, this.comboViewer_familia);
    }

    private void unregisterCombos() {
        ComboManager.unregister(this.comboViewer_pais);
        ComboManager.unregister(this.comboViewer_grupo);
        ComboManager.unregister(this.comboViewer_familia);
    }

    @Override
    public void registerBindings() {
        this.registerBindings(0);
    }

    private void registerBindings(int index) {
        this.bindingSupport.register(FIELDS.entidadesmoradas_morada.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_morada, (int)24), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade().getMoradas(index), (String)FIELDS.entidadesmoradas_morada.name)));
        this.bindingSupport.register(FIELDS.entidadesmoradas_codigopostal.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_codigopostal, (int)24), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade().getMoradas(index), (String)FIELDS.entidadesmoradas_codigopostal.name), (IConverter)new CustomConverter(String.class, Codigospostais.class){

            public Codigospostais convert(Object fromObject) {
                Codigospostais codigopostal = ColibriDatabase.getManager().loadCodigospostais((String)fromObject);
                return codigopostal == null ? new Codigospostais(ColibriDatabase.getManager(), EntidadesRegistoTab1.this.text_codigopostal.getText()) : codigopostal;
            }
        }, (IConverter)new CodigopostalToString()));
        this.bindingSupport.register(FIELDS.entidadesmoradas_localidade.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_localidade, (int)24), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade().getMoradas(index), (String)FIELDS.entidadesmoradas_localidade.name)));
        this.bindingSupport.register(FIELDS.entidadesmoradas_pais.name, new ValueBindingDefinition((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.comboViewer_pais), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade().getMoradas(index), (String)FIELDS.entidadesmoradas_pais.name)));
        this.bindingSupport.register(FIELDS.entidades_nif.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_nif, (int)24), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade(), (String)FIELDS.entidades_nif.name)));
        this.bindingSupport.register(FIELDS.entidades_zona.name, new ValueBindingDefinition((IObservableValue)SWTObservables.observeText((Control)this.text_zona, (int)24), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade(), (String)FIELDS.entidades_zona.name)));
        this.bindingSupport.register(FIELDS.entidades_grupo.name, new ValueBindingDefinition((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.comboViewer_grupo), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade(), (String)FIELDS.entidades_grupo.name)));
        this.bindingSupport.register(FIELDS.entidades_familia.name, new ValueBindingDefinition((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.comboViewer_familia), BeansObservables.observeValue((Object)((ViewParameters)this.view.getParameters()).getEntidade(), (String)FIELDS.entidades_familia.name)));
    }

    @Override
    public void unregisterBindings() {
        this.bindingSupport.unregisterAll();
    }

    @Override
    public void registerValidator() {
        EntidadesRegistoTab1Validator validator = new EntidadesRegistoTab1Validator(this);
        validator.register(FIELDS.entidadesmoradas_morada, (Control)this.button_morada, (Control)this.text_morada, 0);
        validator.register(FIELDS.entidadesmoradas_codigopostal, (Control)this.label_codigopostal, (Control)this.text_codigopostal, FIELDS.codigospostais_codigo, 8);
        validator.register(FIELDS.entidadesmoradas_localidade, null, (Control)this.text_localidade, 0);
        validator.register(FIELDS.entidadesmoradas_pais, (Control)this.label_pais, (Control)this.combo_pais, 4);
        validator.register(FIELDS.entidades_nif, (Control)this.button_nif, (Control)this.text_nif, ((ViewParameters)this.view.getParameters()).getEntidade().isNifEditable() ? 0 : 2);
        validator.register(FIELDS.entidades_zona, (Control)this.label_zona, (Control)this.text_zona, 0);
        validator.register(FIELDS.entidades_grupo, (Control)this.label_grupo, (Control)this.combo_grupo, 4);
        validator.register(FIELDS.entidades_familia, (Control)this.label_familia, (Control)this.combo_familia, 4);
        this.view.getValidationManager().register(LABELS.entidades_tab_geral.name(), (IValidator)validator);
    }

    @Override
    public void unregisterValidator() {
        this.view.getValidationManager().unregister(LABELS.entidades_tab_geral.name());
    }
}

