/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos;

import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.swt.copypaste.CopyPasteManager;
import org.dma.eclipse.swt.copypaste.ICopyPaste;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomComboViewer;
import org.dma.java.util.Debug;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.ILayoutModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.RCPcolibri;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManager;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewAction;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.IViewTableContainer;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.support.views.jobs.EmitirRelatorioJob;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriButton;
import org.projectocolibri.rcp.colibri.workbench.views.ReportView;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosContainer;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosCopyPaste;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosLabelProvider;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.movimentos.ArtigosMovimentosValidator;
import org.projectocolibri.rcp.colibri.workbench.views.filters.FilterView;

public class ArtigosMovimentosView
extends ColibriViewPart<ViewParameters>
implements IViewTableContainer {
    public static final String ID = ArtigosMovimentosView.class.getCanonicalName();
    private Combo combo_pesquisar;
    private Combo combo_operador;
    private Text text_pesquisar;
    private ColibriButton button_pesquisar;
    private Combo combo_filtro;
    private CustomComboViewer<Pesquisas> comboViewer_filtro;
    private Combo combo_template;
    private CustomComboViewer<Templates> comboViewer_template;
    private Combo combo_layout;
    private CustomComboViewer<Layouts> comboViewer_layout;
    private TableViewer tableViewer;
    private ArtigosMovimentosContainer tableContainer;
    private final CopyPasteManager copyPasteManager = new CopyPasteManager((ICopyPaste)new ArtigosMovimentosCopyPaste(this));
    private BIRTReport.REPORT_FORMATS reportFormat = BIRTReport.REPORT_FORMATS.PDF;
    public final CommandAction copiarRegistoAction = new CommandAction(TABLES.artigosmovimentos, Utilizadores.COMMANDS.CopiarRegisto){

        public void run() {
            ArtigosMovimentosView.this.copyPasteManager.executeCopy();
        }

        @Override
        public boolean isValid() {
            return ArtigosMovimentosView.this.tableContainer.getSelectionElement() != null;
        }
    };
    public final CommandAction exportarRegistoAction = new CommandAction(TABLES.artigosmovimentos, Utilizadores.COMMANDS.ExportarRegisto){

        public void run() {
            ArtigosMovimentosView.this.tableContainer.exportTable();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    public final CommandAction pesquisarRegistoAction = new CommandAction(TABLES.artigosmovimentos, Utilizadores.COMMANDS.PesquisarRegisto){

        public void run() {
            ArtigosMovimentosView.this.tableContainer.executeFastSearch();
        }

        @Override
        public boolean isValid() {
            return this.isEnabled();
        }
    };
    public final CommandAction actualizarRegistoAction = new CommandAction(TABLES.artigosmovimentos, Utilizadores.COMMANDS.ActualizarRegisto){

        public void run() {
            ArtigosMovimentosView.this.tableContainer.resetTable();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    public final CommandAction emitirRelatorioAction = new CommandAction(TABLES.artigosmovimentos, Utilizadores.COMMANDS.EmitirRelatorio){

        public void run() {
            new EmitirRelatorioJob(new BIRTReport((Templates)ArtigosMovimentosView.this.comboViewer_template.getSelectedElement()){

                public FilterMap getFilterMap() {
                    return ArtigosMovimentosView.this.tableContainer.getFilterMap();
                }
            }, BIRTReport.REPORT_ACTIONS.PREVIEW, ArtigosMovimentosView.this.reportFormat){

                @Override
                public void task(BIRTReportFile file) {
                }

                @Override
                public void done(BIRTReportFile file) {
                    if (!this.hasError()) {
                        if (RCPcolibri.PREFERENCES.OPEN_SYSTEM_BROWSER.value.getBoolean()) {
                            file.open();
                        } else {
                            new ColibriViewAction(new ViewParameters(ReportView.ID, file)).run(RCPcolibri.PREFERENCES.DETACH_REPORT_VIEW.value.getBoolean());
                        }
                    }
                }
            }.schedule();
        }

        @Override
        public boolean canRun() {
            return ArtigosMovimentosView.this.combo_template.getItemCount() > 0;
        }

        @Override
        public boolean isValid() {
            return !ArtigosMovimentosView.this.isBusy();
        }
    };

    @Override
    public void createControl() {
        this.getActions().addToolItem(this.copiarRegistoAction).addToolItem(this.exportarRegistoAction).add(this.pesquisarRegistoAction).add(this.actualizarRegistoAction).add(this.emitirRelatorioAction);
        Debug.out((String)"PART 1 STARTED");
        this.createContents(this.getParent());
        this.registerCombos();
        this.createControl2();
        Debug.out((String)"PART 1 DONE");
    }

    private void createControl2() {
        Debug.out((String)"PART 2 CALLED");
        if (this.getParameters() == null) {
            return;
        }
        Debug.out((String)"PART 2 STARTED");
        try {
            this.combo_filtro.select(this.getMemento().getInteger(TABLES.pesquisas.name()).intValue());
            this.combo_template.select(this.getMemento().getInteger(TABLES.templates.name()).intValue());
            this.combo_layout.select(this.getMemento().getInteger(TABLES.layouts.name()).intValue());
        }
        catch (Exception exception) {}
        this.createTableContainer();
        this.registerValidator();
        this.setInitialized(true);
        Debug.out((String)"PART 2 DONE");
    }

    private Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        this.createUpperToolBar(composite);
        this.createTableViewer(composite);
        this.createLowerToolBar(composite);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(composite, 67586);
        this.tableViewer = new TableViewer(table);
    }

    private void createTableContainer() {
        Layouts layout = (Layouts)this.comboViewer_layout.getSelectedElement();
        SWTTableLayout tableLayout = new SWTTableLayout(this.tableViewer.getTable(), (ILayoutModel)layout);
        tableLayout.setMinimumWidth(500);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ArtigosMovimentosLabelProvider(tableLayout));
        this.tableContainer = new ArtigosMovimentosContainer(this.tableViewer, tableLayout, this){

            @Override
            public void updateTable(int keycode) {
                super.updateTable(keycode);
                ArtigosMovimentosView.this.setContentDescription(this.getFilterMap().toReadable(ColibriDatabase.getManager().getCampos()));
            }
        };
        this.tableContainer.atach(this.combo_pesquisar, this.combo_operador, this.text_pesquisar, (Button)this.button_pesquisar);
        this.tableContainer.reset(0);
    }

    private void createUpperToolBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.rowHolder());
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Composite holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.rowHolder());
        this.combo_filtro = new Combo(holder, 2064);
        this.combo_filtro.setVisibleItemCount(20);
        this.comboViewer_filtro = new CustomComboViewer(this.combo_filtro);
        ColibriButton[] button_filtro = new ColibriButton[2];
        button_filtro[0] = new ColibriButton(holder, LABELS.operacao_filtro_aplicar);
        button_filtro[0].setImage(Colibri.ICONS.TOOLBAR_APLICAR_FILTRO);
        button_filtro[0].setSelectionAction((IAction)new CustomAction(){

            public void run() {
                if (ArtigosMovimentosView.this.combo_filtro.getItemCount() > 0) {
                    Pesquisas pesquisa = (Pesquisas)ArtigosMovimentosView.this.comboViewer_filtro.getSelectedElement();
                    ArtigosMovimentosView.this.tableContainer.updateTable(pesquisa.userCopy().getFiltroToMap());
                }
            }
        });
        button_filtro[1] = new ColibriButton(holder, LABELS.operacao_filtro_editar);
        button_filtro[1].setImage(Colibri.ICONS.TOOLBAR_EDITAR_FILTRO);
        button_filtro[1].setSelectionAction((IAction)new CustomAction(){

            public void run() {
                if (ArtigosMovimentosView.this.combo_filtro.getItemCount() > 0) {
                    Pesquisas pesquisa = (Pesquisas)ArtigosMovimentosView.this.comboViewer_filtro.getSelectedElement();
                    new ColibriViewAction(new ViewParameters(FilterView.ID, pesquisa.userCopy())).run();
                }
            }
        });
        holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.rowHolder());
        this.combo_template = new Combo(holder, 2064);
        this.combo_template.setVisibleItemCount(20);
        this.comboViewer_template = new CustomComboViewer(this.combo_template);
        final ColibriButton[] button_template = new ColibriButton[2];
        button_template[0] = new ColibriButton(holder, LABELS.operacao_relatorio_emitir);
        button_template[0].setImage(this.reportFormat.icon);
        button_template[0].setSelectionAction(this.emitirRelatorioAction);
        button_template[1] = new ColibriButton(holder, LABELS.operacao_relatorio_formato);
        button_template[1].setImage(Colibri.ICONS.TOOLBAR_FORMATO_RELATORIO);
        button_template[1].setSelectionAction((IAction)new CustomAction(){

            public void run() {
                if (ArtigosMovimentosView.this.combo_template.getItemCount() > 0) {
                    ArtigosMovimentosView.this.reportFormat = ArtigosMovimentosView.this.reportFormat.next();
                    button_template[0].setImage(((ArtigosMovimentosView)ArtigosMovimentosView.this).reportFormat.icon);
                }
            }
        });
        holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.rowHolder());
        this.combo_layout = new Combo(holder, 2064);
        this.combo_layout.setVisibleItemCount(20);
        this.comboViewer_layout = new CustomComboViewer(this.combo_layout);
        ColibriButton[] button_layout = new ColibriButton[2];
        button_layout[0] = new ColibriButton(holder, LABELS.operacao_layout_aplicar);
        button_layout[0].setImage(Colibri.ICONS.TOOLBAR_APLICAR_LAYOUT);
        button_layout[0].setSelectionAction((IAction)new CustomAction(){

            public void run() {
                if (ArtigosMovimentosView.this.combo_layout.getItemCount() > 0) {
                    ArtigosMovimentosView.this.tableContainer.dispose();
                    ArtigosMovimentosView.this.createTableContainer();
                }
            }
        });
        button_layout[1] = new ColibriButton(holder, LABELS.operacao_layout_gravar);
        button_layout[1].setImage(Colibri.ICONS.TOOLBAR_GRAVAR_LAYOUT);
        button_layout[1].setSelectionAction((IAction)new CustomAction(){

            public void run() {
                if (ArtigosMovimentosView.this.combo_layout.getItemCount() > 0) {
                    Layouts layout = (Layouts)ArtigosMovimentosView.this.comboViewer_layout.getSelectedElement();
                    layout.setLayout(ArtigosMovimentosView.this.tableContainer.getTableLayout().getColumnLayout());
                    ColibriDatabase.getManager().storeLayouts(layout);
                }
            }
        });
    }

    private void createLowerToolBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.rowHolder());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.combo_pesquisar = new Combo(composite, 8);
        this.combo_pesquisar.setVisibleItemCount(20);
        this.combo_operador = new Combo(composite, 8);
        this.combo_operador.setVisibleItemCount(20);
        this.text_pesquisar = new Text(composite, 2048);
        this.text_pesquisar.setLayoutData((Object)new RowData(250, -1));
        this.button_pesquisar = new ColibriButton(composite, this.pesquisarRegistoAction);
        new ColibriButton(composite, this.actualizarRegistoAction);
    }

    private void registerCombos() {
        ComboManager.register(TABLES.pesquisas, 1, this.comboViewer_filtro);
        ComboManager.register(TABLES.templates, 1, this.comboViewer_template);
        ComboManager.register(TABLES.layouts, 1, this.comboViewer_layout);
    }

    private void unregisterCombos() {
        ComboManager.unregister(this.comboViewer_filtro);
        ComboManager.unregister(this.comboViewer_template);
        ComboManager.unregister(this.comboViewer_layout);
    }

    private void registerValidator() {
        ArtigosMovimentosValidator validator = new ArtigosMovimentosValidator(this);
        this.validationManager.register(ID, (IValidator)validator).validateAll();
    }

    @Override
    public void initialize(ViewParameters parameters) {
        super.initialize(parameters);
        this.createControl2();
    }

    @Override
    public void setIcon() {
        this.setTitleImage(ColibriDatabase.getManager().getUtilizadoresicones(TreeGroupModel.GROUPS.ARTIGOS, TreeBranchModel.BRANCHES.MOVIMENTOS));
    }

    @Override
    public void setTitle() {
        this.setPartName(LABELS.menutree_artigos_movimentos.toString());
    }

    @Override
    public void setFocus() {
        this.text_pesquisar.setFocus();
    }

    @Override
    public void executeOnPartClosed() {
        this.unregisterCombos();
        this.tableContainer.dispose();
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.setParameters(new ViewParameters(site, ColibriDatabase.getManager().loadEntidadestipos(this.getViewSite().getSecondaryId())));
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putInteger(TABLES.pesquisas.name(), this.combo_filtro.getSelectionIndex());
        memento.putInteger(TABLES.templates.name(), this.combo_template.getSelectionIndex());
        memento.putInteger(TABLES.layouts.name(), this.combo_layout.getSelectionIndex());
    }

    @Override
    public boolean isRestorable() {
        return true;
    }

    @Override
    public ArtigosMovimentosContainer getTableContainer() {
        return this.tableContainer;
    }
}

