/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views.artigos.ficheiro.registo;

import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.support.validators.FieldValidator;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.views.artigos.ficheiro.registo.ArtigosRegistoView;

public class ArtigosRegistoValidator
extends FieldValidator {
    private final ArtigosRegistoView view;

    public ArtigosRegistoValidator(ArtigosRegistoView view) {
        this.view = view;
    }

    public boolean isEdited() {
        return ((ViewParameters)this.view.getParameters()).getArtigo().isEdited();
    }

    public void validateInput() {
        Artigos artigo = ((ViewParameters)this.view.getParameters()).getArtigo();
        if (!this.isEdited() && ColibriDatabase.getManager().existsArtigos(artigo.getCodigo())) {
            this.getProperty(FIELDS.artigos_codigo.name).setError(LABELS.erro_campo_existe.toString());
        }
        if (!artigo.isCodigoValid()) {
            this.getProperty(FIELDS.artigos_codigo.name).setError(LABELS.erro_campo_invalido.toString());
        }
        if (!artigo.isDescricaoValid()) {
            this.getProperty(FIELDS.artigos_descricao.name).setError(LABELS.erro_campo_invalido.toString());
        }
    }

    public void validateButtons() {
        this.view.getActions().validate();
    }
}

