/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.views;

import org.dma.drivers.jdbc.H2WebServer;
import org.dma.java.util.Debug;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.support.views.ColibriViewFile;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewParameters;
import org.projectocolibri.rcp.colibri.workbench.views.BrowserView;

public class DatabaseView
extends BrowserView {
    public static final String ID = DatabaseView.class.getCanonicalName();
    private H2WebServer server;

    @Override
    public void initialize(ViewParameters parameters) {
        ColibriViewFile file = new ColibriViewFile("http://localhost:8082", LABELS.window_database.toString());
        super.initialize(new ViewParameters(ID, file));
    }

    @Override
    public void setIcon() {
        this.setTitleImage(Colibri.ICONS.COOLBAR_DATABASE);
    }

    @Override
    public void executeOnPartOpened() {
        try {
            this.server = new H2WebServer(Colibri.FOLDERS.CONFIG.folder, ColibriDatabase.getManager().getParameters().folder);
            this.server.start();
            Debug.out((String)"H2 WebServer STARTED");
        }
        catch (Exception exception) {
            Debug.out((String)"H2 WebServer RUNNING?");
        }
    }

    @Override
    public void executeOnPartClosed() {
        this.server.stop();
        Debug.out((String)"H2 WebServer STOPED");
        super.dispose();
    }
}

