/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.widgets;

import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.swt.input.validation.IValidationManager;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.input.validation.ValidationManager;
import org.dma.eclipse.swt.widgets.CustomShell;
import org.dma.java.util.Debug;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.actions.ToolbarActionsMap;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTextButton;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.IColibriShell;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.IColibriTabItem;

public class ColibriShell
extends CustomShell
implements IColibriShell {
    private final IValidationManager validationManager = new ValidationManager(){

        public void postError(String message) {
            Debug.err((String)message);
            ColibriUI.postError(message);
        }
    };
    private final ToolbarActionsMap actions = new ToolbarActionsMap();
    private TabFolder tabFolder;

    public ColibriShell(Shell parent, int style) {
        super(parent, style);
    }

    protected void createDefaultButtons(CommandAction saveAction) {
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)LayoutFactory.buttonHolder(2));
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        new ColibriTextButton(composite, LABELS.botao_gravar).setSelectionAction(saveAction);
        this.actions.add(saveAction);
        new ColibriTextButton(composite, LABELS.botao_sair).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                ColibriShell.this.dispose();
            }
        });
    }

    public TabFolder createTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        return this.tabFolder;
    }

    public void register(String property, IValidator validator) {
        this.validationManager.register(property, validator);
    }

    public boolean hasError() {
        return this.validationManager.hasError();
    }

    public void setImage(Colibri.ICONS icon) {
        this.setImage(icon.getImage());
    }

    public void dispose() {
        ColibriUI.clearMessage();
        super.dispose();
    }

    @Override
    public ToolbarActionsMap getActions() {
        return this.actions;
    }

    @Override
    public IColibriTabItem getActiveTab() {
        return (IColibriTabItem)this.tabFolder.getSelection()[0];
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }
}

