/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.views;

import java.awt.image.BufferedImage;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.swt.graphics.ImageManager;
import org.dma.eclipse.swt.input.support.FocusSupport;
import org.dma.eclipse.swt.input.validation.IValidationManager;
import org.dma.eclipse.swt.input.validation.ValidationManager;
import org.dma.eclipse.swt.input.validation.field.IFieldRules;
import org.dma.eclipse.ui.UIHelper;
import org.dma.java.util.Debug;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.model.Utilizadoresicones;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.support.actions.ToolbarActionsMap;
import org.projectocolibri.rcp.colibri.workbench.support.views.IColibriViewPart;
import org.projectocolibri.rcp.colibri.workbench.support.views.IViewStateSupport;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewJobList;
import org.projectocolibri.rcp.colibri.workbench.support.views.ViewTabManager;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.IColibriTabItem;

public abstract class ColibriViewPart<Parameters>
extends ViewPart
implements IColibriViewPart<Parameters>,
IViewStateSupport,
ISaveablePart2,
IFieldRules {
    public static final int DEFAULT = 0;
    protected final ViewJobList jobList = new ViewJobList(){

        @Override
        public void update() {
            ColibriViewPart.this.validationManager.validateAll();
        }
    };
    protected final IValidationManager validationManager = new ValidationManager(){

        public void postError(String message) {
            Debug.err((String)message);
            ColibriUI.postError(message);
        }
    };
    protected final FocusSupport focusSupport = new FocusSupport();
    protected final ViewTabManager tabManager = new ViewTabManager();
    private volatile boolean initialized = false;
    private ToolbarActionsMap actions;
    private TabFolder tabFolder;
    private Parameters parameters;
    private IMemento memento;
    private Composite parent;

    public abstract void createControl();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (!this.isInitialized()) {
            this.createControl();
        }
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    public void setContentDescription(boolean edited) {
        this.setContentDescription("", edited);
    }

    public void setContentDescription(String description, boolean edited) {
        StringBuilder sb = new StringBuilder();
        if (!description.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(description);
        }
        this.setContentDescription(sb.toString());
    }

    public void setTitleImage(Utilizadoresicones icone) {
        this.setTitleImage(icone.getIconeToImage(20));
    }

    public void setTitleImage(Colibri.ICONS icon) {
        this.setTitleImage(icon.getImage(20));
    }

    private void setTitleImage(BufferedImage image) {
        super.setTitleImage(ImageManager.getImage((BufferedImage)image));
    }

    @Deprecated
    protected void setTitleImage(Image titleImage) {
        throw new UnsupportedOperationException();
    }

    public boolean canClose() {
        return this.isDirty() ? this.promptToSaveOnClose() == 1 : true;
    }

    public void close() {
        Debug.out();
        this.setInitialized(false);
        UIHelper.hideView((IViewPart)this);
    }

    public Composite getParent() {
        return this.parent;
    }

    public IMemento getMemento() {
        return this.memento;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
        this.setIcon();
        this.setTitle();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public ToolbarActionsMap getActions() {
        return this.actions;
    }

    public TabFolder createTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        return this.tabFolder;
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    @Override
    public IColibriTabItem getActiveTab() {
        return (IColibriTabItem)this.tabFolder.getSelection()[0];
    }

    public void register(IColibriTabItem tab) {
        this.tabManager.add(tab);
    }

    public FocusSupport getFocusSupport() {
        return this.focusSupport;
    }

    public IValidationManager getValidationManager() {
        return this.validationManager;
    }

    public ViewJobList getJobList() {
        return this.jobList;
    }

    public boolean isBusy() {
        return this.jobList.isBusy();
    }

    @Override
    public void initialize(Parameters parameters) {
        this.setParameters(parameters);
    }

    @Override
    public void setIcon() {
        this.setTitleImage(Colibri.ICONS.WINDOW_VIEW);
    }

    @Override
    public void setTitle() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void executeOnPartOpened() {
        this.setFocus();
    }

    @Override
    public void executeOnPartActivated() {
    }

    @Override
    public void executeOnPartDeactivated() {
    }

    @Override
    public void executeOnPartBroughtToTop() {
    }

    @Override
    public void executeOnPartClosed() {
    }

    @Override
    public void executeOnPartVisible() {
    }

    @Override
    public void executeOnPartHidden() {
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Debug.out((String)site.getId());
        this.actions = new ToolbarActionsMap(site.getActionBars().getToolBarManager());
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
    }

    @Override
    public boolean isRestorable() {
        return false;
    }

    public int promptToSaveOnClose() {
        return UIHelper.isWorkbenchClosing() || this.isBusy() || !QuestionDialog.open((String)LABELS.pergunta_operacao_abandonar.toString(), (String)this.getTitle()) ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.initialized && this.isBusy();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

