/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.tables.viewer;

import java.util.Date;
import org.dma.eclipse.swt.input.support.RegexMatcher;
import org.dma.eclipse.swt.widgets.CustomTable;
import org.dma.java.input.FieldRegex;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.rcp.colibri.workbench.support.CustomFormattedText;
import org.projectocolibri.rcp.colibri.workbench.support.FormatFactory;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.SWTTableLayout;
import org.projectocolibri.rcp.colibri.workbench.support.tables.viewer.TableLayoutContainer;

public abstract class TableSearchContainer<T>
extends TableLayoutContainer<T> {
    private final SelectionListener comboSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableSearchContainer.this.comboSelectionEvent();
        }
    };
    private final KeyListener textEnterKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                TableSearchContainer.this.executeFastSearch();
            }
        }
    };
    private final KeyListener textCursorKeysListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                TableSearchContainer.this.forceFocus();
            }
        }
    };
    private RegexMatcher regexMatcher;
    private CustomFormattedText formattedText;
    private Combo fieldCombo;
    private Combo operatorCombo;
    private Text operandText;
    private Button searchButton;

    public TableSearchContainer(TableViewer viewer, SWTTableLayout tableLayout) {
        this(viewer, tableLayout, 0);
    }

    public TableSearchContainer(TableViewer viewer, SWTTableLayout tableLayout, int dynamicLoad) {
        this(viewer, tableLayout, dynamicLoad, CustomTable.SORT_DIRECTION.ASCENDING);
    }

    public TableSearchContainer(TableViewer viewer, SWTTableLayout tableLayout, int dynamicLoad, CustomTable.SORT_DIRECTION direction) {
        super(viewer, tableLayout, dynamicLoad, direction);
    }

    @Override
    public void dispose() {
        this.detach();
        this.removeListeners();
        super.dispose();
    }

    public void reset(int fieldIndex) {
        this.fieldCombo.setItems(this.getTableLayout().getColumnLabel());
        this.fieldCombo.select(fieldIndex);
        this.comboSelectionEvent();
        this.resetTable();
    }

    public void atach(Combo fieldCombo, Text operandText, Button searchButton) {
        this.atach(fieldCombo, null, operandText, searchButton);
    }

    public void atach(Combo fieldCombo, Combo operatorCombo, Text operandText, Button searchButton) {
        this.removeListeners();
        this.fieldCombo = fieldCombo;
        this.operatorCombo = operatorCombo;
        this.operandText = operandText;
        this.searchButton = searchButton;
        this.addListeners();
    }

    private void detach() {
        if (this.regexMatcher != null) {
            this.regexMatcher.dispose();
        }
        this.regexMatcher = null;
        if (this.formattedText != null) {
            this.formattedText.dispose();
        }
        this.formattedText = null;
    }

    private void addListeners() {
        if (this.fieldCombo != null) {
            this.fieldCombo.addSelectionListener(this.comboSelectionListener);
        }
        if (this.operandText != null) {
            this.operandText.addKeyListener(this.textEnterKeyListener);
            this.operandText.addKeyListener(this.textCursorKeysListener);
        }
    }

    private void removeListeners() {
        if (this.fieldCombo != null) {
            this.fieldCombo.removeSelectionListener(this.comboSelectionListener);
        }
        if (this.operandText != null) {
            this.operandText.removeKeyListener(this.textEnterKeyListener);
            this.operandText.removeKeyListener(this.textCursorKeysListener);
        }
    }

    private void comboSelectionEvent() {
        this.detach();
        int columnIndex = this.fieldCombo.getSelectionIndex();
        if (columnIndex != -1) {
            TableFieldKey fieldKey = (TableFieldKey)this.getTableLayout().get(columnIndex);
            FIELDS field = this.getTableLayout().table.map.get((TableFieldKey)fieldKey).field;
            if (this.operatorCombo != null) {
                this.operatorCombo.setItems(OPERATORS.MATH.GROUPS.find((FIELDS.TYPES)field.type).labels);
                this.operatorCombo.setEnabled(!field.format.isVirtual());
                this.operatorCombo.select(0);
            }
            switch (field.type) {
                default: {
                    break;
                }
                case TIME: 
                case DATE: 
                case DECIMAL: 
                case INTEGER: {
                    this.formattedText = FormatFactory.getFormattedText(field, this.operandText);
                    break;
                }
                case STRING: 
                case LONGSTRING: {
                    this.regexMatcher = new RegexMatcher((Control)this.operandText, (FieldRegex)field.format);
                }
                case BOOLEAN: 
                case BINARY: 
            }
            switch (field.type) {
                default: {
                    break;
                }
                case TIME: 
                case DATE: {
                    this.formattedText.setValue(TimeDateUtils.getCurrentDate());
                    break;
                }
                case DECIMAL: 
                case INTEGER: {
                    break;
                }
                case STRING: 
                case LONGSTRING: {
                    this.operandText.setText("");
                    break;
                }
                case BOOLEAN: {
                    this.operandText.setText(OPERANDS.VALUES.BOOLEAN.ITEMS[0]);
                    break;
                }
                case BINARY: {
                    this.operandText.setText(OPERANDS.VALUES.BINARY.ITEMS[0]);
                }
            }
            switch (field.type) {
                default: {
                    break;
                }
                case TIME: 
                case DATE: 
                case DECIMAL: 
                case INTEGER: 
                case STRING: 
                case LONGSTRING: {
                    this.operandText.setEnabled(!field.format.isVirtual());
                    break;
                }
                case BOOLEAN: 
                case BINARY: {
                    this.operandText.setEnabled(false);
                }
            }
            this.operandText.setFocus();
            this.operandText.selectAll();
            this.operandText.getParent().layout();
            this.searchButton.setEnabled(!field.format.isVirtual());
        }
    }

    public void executeFastSearch() {
        int columnIndex = this.fieldCombo.getSelectionIndex();
        if (columnIndex != -1) {
            TableFieldKey fieldKey = (TableFieldKey)this.getTableLayout().get(columnIndex);
            FIELDS field = this.getTableLayout().table.map.get((TableFieldKey)fieldKey).field;
            OPERATORS.MATH operator = OPERATORS.MATH.GROUPS.find((FIELDS.TYPES)field.type).operators[this.operatorCombo == null ? 0 : this.operatorCombo.getSelectionIndex()];
            String value = this.getValue(field);
            if (value != null) {
                this.updateTable(columnIndex, operator, value);
            }
        }
    }

    private String getValue(FIELDS field) {
        switch (field.type) {
            default: {
                break;
            }
            case TIME: {
                return this.formattedText.getFormatter().getValue() == null ? null : TimeDateUtils.getTimeFormatted((Date)((Date)this.formattedText.getFormatter().getValue()));
            }
            case DATE: {
                return this.formattedText.getFormatter().getValue() == null ? null : TimeDateUtils.getDateFormatted((Date)((Date)this.formattedText.getFormatter().getValue()));
            }
            case DECIMAL: 
            case INTEGER: {
                return this.formattedText.getFormatter().getValue().toString();
            }
            case STRING: 
            case LONGSTRING: {
                break;
            }
            case BOOLEAN: {
                return OPERANDS.VALUES.BOOLEAN.FALSE.value;
            }
            case BINARY: {
                return OPERANDS.VALUES.BINARY.EMPTY.value;
            }
        }
        return this.operandText.getText();
    }
}

