/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.combos;

import org.dma.java.util.Debug;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Combo;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.rcp.colibri.workbench.support.combos.ComboManagerMap;
import org.projectocolibri.rcp.colibri.workbench.support.combos.GlobalCombo;

public class ComboManager {
    private static final ComboManagerMap COMBOS = new ComboManagerMap();

    public static GlobalCombo register(TABLES table, Object secondaryId, ComboViewer viewer) {
        GlobalCombo globalCombo = COMBOS.get(table, secondaryId);
        if (globalCombo == null) {
            globalCombo = new GlobalCombo(table, secondaryId);
            COMBOS.put(globalCombo);
            Debug.out((String)("[" + globalCombo + "] GLOBAL COMBO CREATED"), (Object)COMBOS.size());
            globalCombo.updateCollection();
        }
        globalCombo.addViewer(viewer);
        return globalCombo;
    }

    public static GlobalCombo register(TABLES table, ComboViewer viewer) {
        return ComboManager.register(table, null, viewer);
    }

    public static void unregister(ComboViewer viewer) {
        for (TABLES table : COMBOS.keySet()) {
            for (GlobalCombo globalCombo : ((ComboManagerMap.GlobalComboMap)COMBOS.get(table)).values()) {
                globalCombo.removeViewer(viewer);
            }
        }
        COMBOS.compact();
    }

    public static void update(TABLES table) {
        if (COMBOS.containsKey(table)) {
            for (GlobalCombo globalCombo : ((ComboManagerMap.GlobalComboMap)COMBOS.get(table)).values()) {
                globalCombo.updateViewers();
            }
        }
    }

    public static void update() {
        for (TABLES table : COMBOS.keySet()) {
            ComboManager.update(table);
        }
    }

    public static IDatabaseModel getSelectedObject(Combo combo) {
        for (TABLES table : COMBOS.keySet()) {
            for (GlobalCombo globalCombo : ((ComboManagerMap.GlobalComboMap)COMBOS.get(table)).values()) {
                IDatabaseModel obj = globalCombo.getSelectedObject(combo);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static GlobalCombo getSelectedCombo() {
        for (TABLES table : COMBOS.keySet()) {
            for (GlobalCombo globalCombo : ((ComboManagerMap.GlobalComboMap)COMBOS.get(table)).values()) {
                if (!globalCombo.isFocusControl()) continue;
                return globalCombo;
            }
        }
        return null;
    }
}

