/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.bars.statusbar;

import java.util.concurrent.TimeUnit;
import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.jface.dialogs.message.WarningDialog;
import org.dma.java.net.NTPServerHandler;
import org.dma.java.time.TimerClock;
import org.dma.java.util.MessageList;
import org.dma.java.util.SystemUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.widgets.Display;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.language.Language;
import org.projectocolibri.rcp.colibri.workbench.support.bars.statusbar.CustomActionContributionItem;
import org.projectocolibri.rcp.colibri.workbench.support.bars.statusbar.IColibriStatusBar;

public class ColibriStatusBar
implements IColibriStatusBar {
    private String defaultMessage;
    private final TimerClock clock = new TimerClock(Language.LOCALE, TimerClock.CLOCK_FORMAT.DATE_TIME){
        private final Runnable runnable;
        {
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    ContributionItems.CLOCK.setText(ColibriStatusBar.this.clock.toString());
                }
            };
        }

        public void run() {
            ColibriStatusBar.this.asyncExec(this.runnable);
        }
    }.start();
    private final Display display;
    private final IStatusLineManager statusLine;

    private void asyncExec(Runnable runnable) {
        if (this.display != null && !this.display.isDisposed()) {
            try {
                this.display.asyncExec(runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ColibriStatusBar(Display display, IStatusLineManager statusLine) {
        this.display = display;
        this.statusLine = statusLine;
        ContributionItems[] contributionItemsArray = ContributionItems.values();
        int n = contributionItemsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContributionItems value = contributionItemsArray[n2];
            statusLine.add((IContributionItem)value.item);
            ++n2;
        }
    }

    private void postDefaultMessage() {
        this.statusLine.setMessage(this.defaultMessage == null || this.defaultMessage.isEmpty() ? null : Colibri.ICONS.STATUSBAR_ALERT.getImage(), this.defaultMessage);
    }

    private void postDefaultErrorMessage() {
        this.statusLine.setErrorMessage(this.defaultMessage == null || this.defaultMessage.isEmpty() ? null : Colibri.ICONS.STATUSBAR_ALERT.getImage(), this.defaultMessage);
    }

    @Override
    public void dispose() {
        this.clock.stop();
    }

    @Override
    public void clearMessage() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ColibriStatusBar.this.postDefaultMessage();
                ColibriStatusBar.this.postDefaultErrorMessage();
            }
        });
    }

    @Override
    public void setDefaultMessage(String message) {
        this.defaultMessage = message;
    }

    @Override
    public void postMessage(final String message) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (message == null || message.isEmpty()) {
                    ColibriStatusBar.this.postDefaultMessage();
                } else {
                    ColibriStatusBar.this.statusLine.setMessage(Colibri.ICONS.STATUSBAR_SUCCESS.getImage(), message);
                }
            }
        });
    }

    @Override
    public void postError(final String message) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (message == null || message.isEmpty()) {
                    ColibriStatusBar.this.postDefaultErrorMessage();
                } else {
                    ColibriStatusBar.this.statusLine.setErrorMessage(Colibri.ICONS.STATUSBAR_ERROR.getImage(), message);
                }
            }
        });
    }

    public static enum ContributionItems {
        USER(new CustomActionContributionItem(ColibriDatabase.getManager().getUtilizador())),
        DATABASE(new CustomActionContributionItem(ColibriDatabase.getManager().getParameters())),
        LICENCE(new CustomActionContributionItem(ColibriDatabase.getManager().getLicenca())),
        SYSTEM(new CustomActionContributionItem(new MessageList(new String[]{String.valueOf(SystemUtils.OS_NAME) + " " + SystemUtils.OS_ARCH, String.valueOf(SystemUtils.JAVA_NAME) + " " + SystemUtils.JAVA_ARCH}), SystemUtils.OS_NAME)),
        CLOCK(new ActionContributionItem((IAction)new Action(){
            private final long MAX_OFFSET = TimeUnit.SECONDS.toMillis(60L);

            public void run() {
                NTPServerHandler.NTPTimeInfo info = NTPServerHandler.NTP_SERVERS.queryAll((int)1000);
                if (info == null) {
                    ErrorDialog.open((String)"Please check internet connection!");
                } else if (info.getOffset() == null) {
                    WarningDialog.open((String)"Offset not available!");
                } else if (Math.abs(info.getOffset()) > this.MAX_OFFSET) {
                    WarningDialog.open((String)info.toText());
                } else {
                    InformationDialog.open((String)info.toText());
                }
            }
        }));

        public final ContributionItem item;

        private ContributionItems(ActionContributionItem item) {
            this.item = item == null || !ColibriDatabase.getManager().getUtilizador().isColibri() ? new StatusLineContributionItem(this.name(), -1) : item;
            String text = item == null ? null : item.getAction().getText();
            this.setText(text == null ? "" : text);
        }

        public String getText() {
            if (this.item instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)this.item).getAction();
                return action.getText();
            }
            if (this.item instanceof StatusLineContributionItem) {
                return ((StatusLineContributionItem)this.item).getText();
            }
            return null;
        }

        public void setText(String text) {
            if (this.item instanceof ActionContributionItem) {
                if (!text.equals(this.getText())) {
                    ((ActionContributionItem)this.item).getAction().setText(text);
                    IContributionManager manager = this.item.getParent();
                    if (manager != null) {
                        manager.update(true);
                    }
                }
            } else if (this.item instanceof StatusLineContributionItem) {
                ((StatusLineContributionItem)this.item).setText(text);
            }
        }
    }
}

