/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.support.actions;

import java.util.LinkedHashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.projectocolibri.rcp.colibri.workbench.support.actions.ICommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.actions.IToolbarActionsMap;

public class ToolbarActionsMap
extends LinkedHashMap<String, ICommandAction>
implements IToolbarActionsMap {
    private static final long serialVersionUID = 1L;
    private final IToolBarManager toolBarManager;

    public ToolbarActionsMap() {
        this((IToolBarManager)new ToolBarManager());
    }

    public ToolbarActionsMap(IToolBarManager toolBarManager) {
        this.toolBarManager = toolBarManager;
    }

    public ICommandAction get(Enum command) {
        return (ICommandAction)this.get(command.name());
    }

    @Override
    public ICommandAction get(Command command) {
        try {
            return (ICommandAction)this.get(command.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ToolbarActionsMap remove(String id) {
        ICommandAction action = (ICommandAction)super.remove(id);
        if (action != null) {
            this.toolBarManager.remove(action.getId());
        }
        return this;
    }

    public ToolbarActionsMap remove(Enum command) {
        return this.remove(command.name());
    }

    public ToolbarActionsMap remove(ICommandAction action) {
        return action != null ? this.remove(action.getId()) : this;
    }

    public ToolbarActionsMap add(ICommandAction action) {
        if (this.containsKey(action.getId())) {
            throw new RuntimeException("ACTION ALREADY REGISTERED: " + action.getId());
        }
        return this.remove(this.put(action.getId(), action));
    }

    public ToolbarActionsMap addToolItem(ICommandAction action) {
        IContributionItem item = this.toolBarManager.find(action.getId());
        if (item == null) {
            this.remove(action);
            this.toolBarManager.add((IAction)action);
        } else {
            this.toolBarManager.insertAfter(action.getId(), (IAction)action);
            this.remove(action);
        }
        this.put(action.getId(), action);
        return this;
    }

    @Override
    public void validate() {
        for (ICommandAction action : this.values()) {
            action.validate();
        }
    }

    @Override
    public void update() {
        this.validate();
        this.toolBarManager.update(false);
    }

    public void enable() {
        for (ICommandAction action : this.values()) {
            action.setEnabled(true);
        }
    }

    public void disable() {
        for (ICommandAction action : this.values()) {
            action.setEnabled(false);
        }
    }
}

