/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.templates.shell;

import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.templates.shell.TemplatesShell;
import org.projectocolibri.rcp.colibri.workbench.support.validators.FieldValidator;

public class TemplatesShellValidator
extends FieldValidator {
    private final TemplatesShell shell;

    public TemplatesShellValidator(TemplatesShell shell) {
        this.shell = shell;
    }

    public boolean isEdited() {
        return this.shell.getTemplate().isEdited();
    }

    public void validateInput() {
        if (!this.isEdited() && ColibriDatabase.getManager().existsTemplates(this.shell.getTemplate().getCodigo())) {
            this.getProperty(FIELDS.templates_codigo.name).setError(LABELS.erro_campo_existe.toString());
        }
        if (this.shell.getTemplate().isTipo(Integer.valueOf(0))) {
            this.getProperty(FIELDS.templates_layout.name).disable();
            this.getProperty(FIELDS.templates_layout, 2).disable();
        }
        if (!this.shell.getTemplate().isLayoutValid()) {
            this.getProperty(FIELDS.templates_layout.name).setError(LABELS.erro_campo_invalido.toString());
        }
    }

    public void validateButtons() {
        this.shell.getActions().validate();
    }
}

