/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.tabelas.configuracao.templates;

import java.io.File;
import java.util.Collection;
import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.eclipse.core.jobs.UIAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.manager.tasks.TemplatesTask;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.ColibriUIJob;

public class TemplatesJob
extends ColibriUIJob {
    private final TemplatesTask task = new TemplatesTask(ColibriDatabase.getManager());

    public CustomJob importFrom(final File designFile, final Templates template) {
        this.setName(LABELS.operacao_template_importar.toString());
        this.addTask((IAction)new Action(template.toString()){

            public void run() {
                TemplatesJob.this.addError(TemplatesJob.this.task.importDesign(designFile, template.getCodigo()));
            }
        }).addTask((IAction)new UIAction(){

            public void run() {
                TemplatesJob.this.showTip(LABELS.info_operacao_concluida.toString());
            }
        });
        return this;
    }

    public CustomJob importFrom(final File folder, Collection<Templates> col) {
        this.setName(LABELS.operacao_template_importar.toString());
        for (final Templates template : col) {
            this.addTask((IAction)new Action(template.toString()){

                public void run() {
                    TemplatesJob.this.addError(TemplatesJob.this.task.importFrom(folder, template.getCodigo()));
                }
            });
        }
        this.addTask((IAction)new UIAction(){

            public void run() {
                TemplatesJob.this.showTip(LABELS.info_operacao_concluida.toString());
            }
        });
        return this;
    }

    public CustomJob exportTo(final File folder, Collection<Templates> col) {
        this.setName(LABELS.operacao_template_exportar.toString());
        for (final Templates template : col) {
            this.addTask((IAction)new Action(template.toString()){

                public void run() {
                    TemplatesJob.this.addError(TemplatesJob.this.task.exportTo(folder, template.getCodigo()));
                }
            });
        }
        this.addTask((IAction)new UIAction(){

            public void run() {
                TemplatesJob.this.showTip(LABELS.info_operacao_concluida.toString());
            }
        });
        return this;
    }
}

