/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.documentos.ficheiro;

import java.io.File;
import java.util.Calendar;
import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.swt.dialogs.file.FolderDialog;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomDateTime;
import org.dma.java.io.Folder;
import org.dma.java.time.CalendarPeriod;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.documentos.ficheiro.SAFTExportJob;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.documentos.ficheiro.SAFTExportValidator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.preferences.ColibriPreferencePage;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import org.projectocolibri.xml.beans.saft.x0101.SAFTx0101Export;
import org.projectocolibri.xml.beans.saft.x0201.SAFTx0201Export;
import org.projectocolibri.xml.beans.saft.x0301.SAFTx0301Export;
import org.projectocolibri.xml.beans.saft.x0401.SAFTx0401Export;

public class SAFTExport
extends ColibriPreferencePage {
    private Label label_versao;
    private Label label_periodo;
    private final CustomDateTime[] date_periodo = new CustomDateTime[2];
    private List list_versao;
    private List list_tipo;
    private final BindingSupport bindingSupport = new BindingSupport();
    final CommandAction executarAction = new CommandAction(TABLES.empresa, Utilizadores.COMMANDS.Processamentos){

        public void run() {
            Folder folder = new FolderDialog(SAFTExport.this.getShell(), new String[0]).folderPicker();
            if (folder != null) {
                CalendarPeriod period = new CalendarPeriod(SAFTExport.this.date_periodo[0].getCalendar(), SAFTExport.this.date_periodo[1].getCalendar());
                ISAFTExport.SAFT_TYPE type = ISAFTExport.SAFT_TYPE.get((String)SAFTExport.this.list_tipo.getSelection()[0]);
                switch (ISAFTExport.SAFT_VERSIONS.values()[SAFTExport.this.list_versao.getSelectionIndex()]) {
                    case x0101: {
                        new SAFTExportJob((ISAFTExport)new SAFTx0101Export(ColibriDatabase.getManager(), period), type, (File)folder).schedule();
                        break;
                    }
                    case x0201: {
                        new SAFTExportJob((ISAFTExport)new SAFTx0201Export(ColibriDatabase.getManager(), period), type, (File)folder).schedule();
                        break;
                    }
                    case x0301: {
                        new SAFTExportJob((ISAFTExport)new SAFTx0301Export(ColibriDatabase.getManager(), period), type, (File)folder).schedule();
                        break;
                    }
                    case x0401: {
                        new SAFTExportJob((ISAFTExport)new SAFTx0401Export(ColibriDatabase.getManager(), period), type, (File)folder).schedule();
                    }
                }
            }
        }

        @Override
        public boolean isValid() {
            return !SAFTExport.this.hasError();
        }

        @Override
        public boolean hasPermission() {
            return ColibriDatabase.getManager().getUtilizador().getPermissions(this.table).contains(this.command);
        }
    };

    public SAFTExport() {
        super(LABELS.processamentos_documentos_ficheiro.toString());
        this.getActions().add(this.executarAction);
    }

    public Control createContents(Composite parent) {
        this.createComposite(parent);
        this.createExecuteButton(parent, Utilizadores.COMMANDS.Processamentos);
        this.registerValidator();
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout(2));
        Composite holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.gridHolder());
        this.label_periodo = new Label(holder, 0);
        this.label_periodo.setText(LABELS.processamentos_documentos_ficheiro_periodo.toString());
        Calendar calendar = TimeDateUtils.addMonths((Calendar)TimeDateUtils.getCalendar(), (int)-1);
        this.date_periodo[0] = new CustomDateTime(holder, 1024);
        this.date_periodo[0].setDate(TimeDateUtils.getYear((Calendar)calendar), TimeDateUtils.getMonth((Calendar)calendar), 1);
        holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.gridHolder());
        new Label(holder, 0);
        this.date_periodo[1] = new CustomDateTime(holder, 1024);
        this.date_periodo[1].setDate(TimeDateUtils.getYear((Calendar)calendar), TimeDateUtils.getMonth((Calendar)calendar), TimeDateUtils.getDayOfMonthMax((Calendar)calendar));
        holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.gridHolder());
        holder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.label_versao = new Label(holder, 0);
        this.label_versao.setText(LABELS.processamentos_documentos_ficheiro_versao.toString());
        this.list_versao = new List(holder, 2048);
        this.list_versao.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list_versao.setItems(ISAFTExport.SAFT_VERSIONS.ITEMS);
        this.list_versao.select(ISAFTExport.SAFT_VERSIONS.DEFAULT.ordinal());
        holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.gridHolder());
        holder.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(holder, 0);
        this.list_tipo = new List(holder, 2048);
        this.list_tipo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list_tipo.setItems(ISAFTExport.SAFT_TYPE.NAMES);
        this.list_tipo.select(0);
        return composite;
    }

    private void registerValidator() {
        SAFTExportValidator validator = new SAFTExportValidator(this);
        validator.register(String.valueOf(LABELS.processamentos_documentos_ficheiro_periodo.name()) + "1", (Control)this.label_periodo, (Control)this.date_periodo[0], 0);
        validator.register(String.valueOf(LABELS.processamentos_documentos_ficheiro_periodo.name()) + "2", (Control)this.label_periodo, (Control)this.date_periodo[1], 0);
        validator.register(LABELS.processamentos_documentos_ficheiro_versao.name(), (Control)this.label_versao, (Control)this.list_versao, 0);
        this.register(this.getTitle(), (IValidator)validator);
    }
}

