/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.artigos.inventario;

import java.io.File;
import java.util.Calendar;
import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.swt.dialogs.file.FolderDialog;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.dma.eclipse.swt.widgets.CustomDateTime;
import org.dma.java.io.Folder;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.artigos.inventario.StocksExportJob;
import org.projectocolibri.rcp.colibri.workbench.preferences.processamentos.artigos.inventario.StocksExportValidator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CommandAction;
import org.projectocolibri.rcp.colibri.workbench.support.preferences.ColibriPreferencePage;
import org.projectocolibri.xml.beans.stocks.IStocksExport;
import org.projectocolibri.xml.beans.stocks.x102.Stocks102Export;
import org.projectocolibri.xml.beans.stocks.x201.Stocks201Export;

public class StocksExport
extends ColibriPreferencePage {
    private Label label_periodo;
    private CustomDateTime date_datafinal;
    private final BindingSupport bindingSupport = new BindingSupport();
    final CommandAction executarAction = new CommandAction(TABLES.empresa, Utilizadores.COMMANDS.Processamentos){

        public void run() {
            Folder folder = new FolderDialog(StocksExport.this.getShell(), new String[0]).folderPicker();
            if (folder != null) {
                switch (IStocksExport.STOCKS_VERSIONS.DEFAULT) {
                    case x102: {
                        new StocksExportJob((IStocksExport)new Stocks102Export(ColibriDatabase.getManager(), StocksExport.this.date_datafinal.getCalendar()), (File)folder).schedule();
                        break;
                    }
                    case x201: {
                        new StocksExportJob((IStocksExport)new Stocks201Export(ColibriDatabase.getManager(), StocksExport.this.date_datafinal.getCalendar()), (File)folder).schedule();
                    }
                }
            }
        }

        @Override
        public boolean isValid() {
            return !StocksExport.this.hasError();
        }
    };

    public StocksExport() {
        super(LABELS.processamentos_artigos_inventario.toString());
        this.getActions().add(this.executarAction);
    }

    public Control createContents(Composite parent) {
        this.createComposite(parent);
        this.createExecuteButton(parent, Utilizadores.COMMANDS.Processamentos);
        this.registerValidator();
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        Composite holder = new Composite(composite, 0);
        holder.setLayout((Layout)LayoutFactory.gridHolder());
        this.label_periodo = new Label(holder, 0);
        this.label_periodo.setText(LABELS.processamentos_artigos_inventario_data.toString());
        this.date_datafinal = new CustomDateTime(holder, 1024);
        this.date_datafinal.setDate(TimeDateUtils.getCalendarDayMax((Calendar)TimeDateUtils.getCalendarMonthMax((Calendar)TimeDateUtils.addYears((Calendar)TimeDateUtils.getCalendar(), (int)-1))));
        return composite;
    }

    private void registerValidator() {
        StocksExportValidator validator = new StocksExportValidator(this);
        validator.register(LABELS.processamentos_artigos_inventario_data.name(), (Control)this.label_periodo, (Control)this.date_datafinal, 8);
        this.register(this.getTitle(), (IValidator)validator);
    }
}

