/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.preferences.parametros.empresa.nodes.certificados;

import org.dma.eclipse.core.bindings.BindingSupport;
import org.dma.eclipse.jface.CustomAction;
import org.dma.eclipse.jface.dialogs.input.PasswordDialog;
import org.dma.eclipse.swt.dialogs.file.FileImport;
import org.dma.eclipse.swt.input.validation.IValidator;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.rcp.colibri.workbench.preferences.parametros.empresa.EmpresaPreference;
import org.projectocolibri.rcp.colibri.workbench.preferences.parametros.empresa.nodes.certificados.EmpresaNode3Validator;
import org.projectocolibri.rcp.colibri.workbench.support.LayoutFactory;
import org.projectocolibri.rcp.colibri.workbench.support.preferences.ColibriPreferencePage;
import org.projectocolibri.rcp.colibri.workbench.support.widgets.ColibriTextButton;

public class EmpresaNode3
extends ColibriPreferencePage {
    private Composite composite;
    private Text text_certificado;
    private final BindingSupport bindingSupport = new BindingSupport();
    private final EmpresaPreference preference;

    public EmpresaPreference getPreference() {
        return this.preference;
    }

    public EmpresaNode3(LABELS title, EmpresaPreference preference) {
        super(title.toString(), preference);
        this.preference = preference;
    }

    public Control createContents(Composite parent) {
        this.createButtons(parent);
        this.composite = this.createComposite(parent);
        this.registerValidator();
        this.loadCertificate();
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void loadCertificate() {
        this.text_certificado.setText(this.preference.getEmpresa().getCertificadoToText());
        this.text_certificado.pack();
        this.composite.pack();
    }

    private void importCertificate(byte[] bytes, String password) {
        this.preference.getEmpresa().setCertificado(bytes, password);
        this.loadCertificate();
    }

    private void importCertificate() {
        byte[] bytes = new FileImport(this.getShell(), new String[]{"*.pfx"}).readBytes();
        if (bytes == null) {
            return;
        }
        String password = new PasswordDialog(this.getShell(), this.getTitle(), LABELS.empresa_jkspassword.toString()).getValue();
        if (password != null) {
            this.importCertificate(bytes, password);
        }
    }

    private void removeCertificate() {
        this.importCertificate(null, "");
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.gridLayout());
        this.text_certificado = new Text(composite, 66);
        this.text_certificado.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.text_certificado.setEditable(false);
        return composite;
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutFactory.buttonHolder(2));
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        new ColibriTextButton(composite, LABELS.botao_importar).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                EmpresaNode3.this.importCertificate();
            }
        });
        new ColibriTextButton(composite, LABELS.botao_remover).setSelectionAction((IAction)new CustomAction(){

            public void run() {
                EmpresaNode3.this.removeCertificate();
            }
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void registerValidator() {
        EmpresaNode3Validator validator = new EmpresaNode3Validator(this);
        this.register(this.getTitle(), (IValidator)validator);
    }
}

