/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri.workbench.actions;

import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.ui.UIHelper;
import org.dma.java.util.Debug;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.remote.RemoteUpdateFileJob;
import org.projectocolibri.core.remote.updates.UpdateFileHandler;
import org.projectocolibri.core.support.install.RemoteFile;
import org.projectocolibri.rcp.colibri.workbench.ColibriUI;
import org.projectocolibri.rcp.colibri.workbench.shells.update.UpdateShell;
import org.projectocolibri.rcp.colibri.workbench.support.actions.CoolbarAction;

public class RemoteUpdateAction
extends CoolbarAction {
    public RemoteUpdateAction() {
        super(LABELS.menuoption_ajuda_actualizacao.toString());
        this.setImageDescriptor(Colibri.ICONS.COOLBAR_ACTUALIZACAO);
    }

    public void run() {
        Debug.out((String)this.getText());
        new RemoteUpdateFileJob(){

            public void error() {
                ErrorDialog.open((String)RemoteUpdateAction.this.getText(), (String)LABELS.info_operacao_falhada.toString());
            }

            public void done(UpdateFileHandler handler) {
                Debug.out((Object)handler.getHeader());
                RemoteFile file = handler.getRemoteFile(Colibri.INSTALL_PLATFORM);
                if (file != null) {
                    if (handler.getHeader().contains(ColibriDatabase.getManager().getLicenca().getNifTitular()) && file.update()) {
                        InformationDialog.open((String)LABELS.info_versao_disponivel.toString(), (String)LABELS.info_aplicacao_reiniciar.toString());
                    } else {
                        ColibriUI.showTip(RemoteUpdateAction.this.getText(), LABELS.info_versao_actualizada.toString());
                    }
                } else if (Colibri.INSTALL_PLATFORM == null) {
                    new UpdateShell(UIHelper.getWorkbenchShell(), handler).open();
                } else {
                    this.error();
                }
            }
        }.schedule();
    }
}

