/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.rcp.colibri;

import org.dma.eclipse.jface.dialogs.message.ErrorDialog;
import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.jface.dialogs.message.WarningDialog;
import org.dma.eclipse.jface.dialogs.progress.IProgressAction;
import org.dma.eclipse.jface.dialogs.progress.ProgressSupport;
import org.dma.eclipse.jface.preference.IPreferenceValue;
import org.dma.java.util.Debug;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageList;
import org.dma.java.util.SystemUtils;
import org.dma.java.util.TimeDateUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.remote.RemoteControlFileJob;
import org.projectocolibri.core.remote.control.ControlFileHandler;
import org.projectocolibri.core.support.install.RemoteFile;
import org.projectocolibri.rcp.colibri.Activator;
import org.projectocolibri.rcp.colibri.workbench.actions.AutomaticUpdateAction;
import org.projectocolibri.rcp.colibri.workbench.actions.SeriesAutomaticasAction;
import org.projectocolibri.ui.login.shell.LoginShell;
import org.projectocolibri.xml.beans.empresas.ColibriEmpresa;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class RCPcolibri {
    public static boolean update() {
        final RemoteFile file = new RemoteFile();
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL && file.isValid()) {
            if (!PREFERENCES.UPDATE_EXECUTED.value.getBoolean()) {
                if (QuestionDialog.open((String)Colibri.FILES.MESSAGES.UPDATES_AUTOMATICOS.text)) {
                    block12: {
                        block13: {
                            if (!ColibriLicenca.load().allows(Colibri.FUNCIONALIDADES.ACTUALIZACAO_AUTOMATICA)) break block12;
                            if (file.isMicro()) break block13;
                            if (!ColibriEmpresa.isH2Embedded()) {
                                WarningDialog.open((String)Colibri.FILES.MESSAGES.UPDATES_MULTIPOSTO.text);
                            }
                            ProgressSupport progress = new ProgressSupport(LABELS.info_database_backupexecucao.toString());
                            for (EmpresaDocument.Empresa empresa : ColibriEmpresa.getDatabase().getCollection()) {
                                final DatabaseParameters parameters = new DatabaseParameters(empresa);
                                progress.put(new IProgressAction(){

                                    public void run(IProgressMonitor monitor) throws Exception {
                                        parameters.executeBackup();
                                    }
                                }, parameters.toString());
                            }
                            if (progress.run()) break block13;
                            return false;
                        }
                        file.dst().exists();
                        boolean exists = false;
                        ProgressSupport progress = new ProgressSupport(LABELS.info_aplicacao_download.toString());
                        progress.put(new IProgressAction(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                file.download(monitor);
                            }
                        }, file.getName());
                        if (exists || progress.run()) {
                            do {
                                PREFERENCES.UPDATE_EXECUTED.value.setValue(file.dst().open());
                            } while (!PREFERENCES.UPDATE_EXECUTED.value.getBoolean() && QuestionDialog.open((String)Colibri.FILES.MESSAGES.UPDATES_INSTALADOR.text));
                            return PREFERENCES.UPDATE_EXECUTED.value.getBoolean();
                        }
                        return false;
                    }
                    try {
                        return Colibri.WEBPAGES.INSTALACAO.browse();
                    }
                    catch (Exception e) {
                        ErrorDialog.open((String)LABELS.info_operacao_falhada.toString(), (MessageList)new MessageList((Throwable)e));
                    }
                }
            } else {
                return InformationDialog.open((String)Colibri.FILES.MESSAGES.INSTALACAO_INACTIVA.text);
            }
        }
        file.reset();
        return false;
    }

    public static ColibriDatabase.LOGIN_RESULT login(Display display) {
        return new LoginShell(display){

            public ErrorList doLogin(ColibriLicenca licenca, DatabaseParameters parameters, String user, String password) {
                if (PREFERENCES.AUTOMATIC_BACKUPS.value.getBoolean() && !PREFERENCES.BACKUP_EXECUTED.value.getBoolean()) {
                    try {
                        parameters.executeBackup();
                        PREFERENCES.BACKUP_EXECUTED.value.setValue(true);
                    }
                    catch (Exception e) {
                        ErrorDialog.open((String)LABELS.erro_database_backupfalhado.toString(), (MessageList)new MessageList((Throwable)e));
                    }
                }
                return super.doLogin(licenca, parameters, user, password);
            }
        }.getResult();
    }

    public static void run() {
        Debug.err();
        if (PREFERENCES.REMOTE_MESSAGES.value.getBoolean()) {
            new RemoteControlFileJob(){

                public void error() {
                }

                public void done(ControlFileHandler handler) {
                    InformationDialog.open((MessageList)handler.getMessageList(TimeDateUtils.getCurrentDate()));
                }
            }.schedule();
        }
        if (!PREFERENCES.AUTOMATIC_BACKUPS.value.getBoolean() && PREFERENCES.BACKUPS_WARNING.value.getBoolean()) {
            InformationDialog.open((String)Colibri.FILES.MESSAGES.BACKUPS_AUTOMATICOS.text);
            PREFERENCES.BACKUPS_WARNING.value.setValue(false);
        }
        if (PREFERENCES.AUTOMATIC_UPDATES.value.getBoolean()) {
            new AutomaticUpdateAction().run();
        }
        if (PREFERENCES.AUTOMATIC_SERIES.value.getBoolean()) {
            new SeriesAutomaticasAction().run();
        }
    }

    public static enum PREFERENCES {
        CONFIRM_ON_EXIT(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP),
        TRAVERSE_KEYPAD_ENTER(true),
        SINGLE_CLICK_EDIT(false),
        OPEN_CELL_COMBOS(!SystemUtils.IS_OS_LINUX),
        HIDE_INACTIVE_RECORDS(true),
        SHOW_TREE_ICONS(true),
        SHOW_RESIZED_ICONS(true),
        SHOW_TEXT_BUTTONS(false),
        SHOW_BASE_VIEW(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP),
        DETACH_REPORT_VIEW(false),
        OPEN_SYSTEM_BROWSER(!SystemUtils.IS_OS_WINDOWS),
        OPEN_DOCUMENTS_VIEW(false),
        SAVE_AND_RESTORE(true),
        MINIMIZE_TO_TRAY(false),
        REMOTE_MESSAGES(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP && Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL),
        AUTOMATIC_BACKUPS(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP),
        AUTOMATIC_UPDATES(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP && Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL),
        AUTOMATIC_SERIES(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP),
        BACKUPS_WARNING(Colibri.VERSION_TYPE == Colibri.VERSIONS.DESKTOP),
        BACKUP_EXECUTED(false),
        UPDATE_EXECUTED(false);

        public final IPreferenceValue value;

        static {
            PREFERENCES.BACKUP_EXECUTED.value.setToDefault();
        }

        private PREFERENCES(Object defaultValue) {
            this.value = Activator.PLUGIN_STORE.getValue(this.name(), defaultValue);
        }
    }
}

