/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SeperatorSection
extends Section {
    private int style;
    protected Label seperator;
    private int width = -1;
    private boolean fillSeperator = true;

    public SeperatorSection(Composite parent, int style) {
        super(" ", parent, false);
        this.style = style;
    }

    public void createSection() {
        this.getSeperatorControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public Label getSeperatorControl() {
        return this.seperator;
    }

    protected Label getSeperatorControl(Composite parent) {
        if (this.seperator == null) {
            this.seperator = FormWidgetFactory.getInstance().createSeparator(parent, this.style);
            this.seperator.setLayoutData((Object)new GridData());
            this.seperator.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SeperatorSection.this.seperator = null;
                }
            });
        } else {
            this.checkParent((Control)this.seperator, parent);
        }
        return this.seperator;
    }

    public void layout() {
        GridData gd = (GridData)this.seperator.getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillSeperator;
        }
    }

    public void load() {
    }

    public void setInput(Object input) {
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillSeperator() {
        return this.fillSeperator;
    }

    public void setFillSeperator(boolean fillSeperator) {
        this.fillSeperator = fillSeperator;
    }

    public void setHidden(boolean isHidden) {
        if (this.seperator != null) {
            WidgetUtil.setExcludeGridData((Control)this.seperator, (boolean)isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.seperator != null) {
            this.seperator.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

