/*
 * Decompiled with CFR 0.152.
 */
package org.dma.jaxrs.responses;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.dma.java.util.StringUtils;
import org.dma.jaxrs.responses.IResponse;

public class ResponseBuilder<T>
extends HashMap<String, Object>
implements IResponse {
    private static final long serialVersionUID = 1L;
    private final Response.StatusType status;
    private final T entity;

    public Response.StatusType getStatus() {
        return this.status;
    }

    public T getEntity() {
        return this.entity;
    }

    public ResponseBuilder(Response.Status status) {
        this((Response.StatusType)status, null);
    }

    public ResponseBuilder(Response.StatusType status, T entity) {
        this.status = status;
        this.entity = entity;
    }

    public ResponseBuilder(Response response) {
        this.status = Response.Status.fromStatusCode((int)response.getStatus());
        this.entity = response.getEntity();
        for (String header : response.getHeaders().keySet()) {
            this.setHeader(header, response.getHeaders().get((Object)header));
        }
    }

    @Override
    public Response build() {
        Response.ResponseBuilder builder = Response.status((Response.StatusType)this.status).entity(this.entity);
        for (String key : this.keySet()) {
            builder.header(key, this.get(key));
        }
        return builder.build();
    }

    public ResponseBuilder<T> text(Charset charset) {
        return this.setHeader("Content-Type", "text/html; charset=" + charset.name());
    }

    public ResponseBuilder<T> attachment(File file) {
        return this.setHeader("Content-Disposition", "attachment; filename=" + StringUtils.quote((String)file.getName(), (char[])new char[0]));
    }

    public ResponseBuilder<T> setHeader(String header, Object value) {
        this.put(header, value);
        return this;
    }

    public boolean isInformation() {
        return this.status.getFamily() == Response.Status.Family.INFORMATIONAL;
    }

    public boolean isSuccess() {
        return this.status.getFamily() == Response.Status.Family.SUCCESSFUL;
    }

    public boolean isRedirect() {
        return this.status.getFamily() == Response.Status.Family.REDIRECTION;
    }

    public boolean isClientError() {
        return this.status.getFamily() == Response.Status.Family.CLIENT_ERROR;
    }

    public boolean isServerError() {
        return this.status.getFamily() == Response.Status.Family.SERVER_ERROR;
    }

    @Override
    public String toString() {
        return String.valueOf(ResponseBuilder.class.getCanonicalName()) + " [status=" + this.status + ", entity=" + this.entity + "]";
    }
}

