/*
 * Decompiled with CFR 0.152.
 */
package org.dma.jaxrs.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.dma.jaxrs.resources.ResourceInfo;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;

public class ResourceInfoMap
extends LinkedHashMap<String, Collection<ResourceInfo>> {
    private static final long serialVersionUID = 1L;
    private final Resource resource;

    public ResourceInfoMap(Class resourceClass) {
        this(Resource.from((Class)resourceClass));
    }

    public ResourceInfoMap(Resource resource) {
        this.resource = resource;
        if (resource != null) {
            this.process(resource);
        }
    }

    private void process(Resource resource) {
        for (Resource childResource : resource.getChildResources()) {
            this.process(childResource);
        }
        for (ResourceMethod method : resource.getAllMethods()) {
            if (method.getType().equals((Object)ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR)) {
                this.process(Resource.from(resource.getResourceLocator().getInvocable().getDefinitionMethod().getReturnType()));
                continue;
            }
            if (resource.getPath().equals(this.resource.getPath())) continue;
            ArrayList<ResourceInfo> list = (ArrayList<ResourceInfo>)this.get(resource.getPath());
            if (list == null) {
                list = new ArrayList<ResourceInfo>();
                this.put(resource.getPath(), list);
            }
            list.add(new ResourceInfo(method, resource.getPath()));
        }
    }

    public void print(String basePath) {
        if (this.resource != null) {
            System.out.println("[" + basePath + this.resource.getPath() + "]");
        }
        for (String key : this.keySet()) {
            for (ResourceInfo info : (Collection)this.get(key)) {
                System.out.println(info);
            }
        }
    }

    public void print() {
        this.print("");
    }
}

