/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.QueryUIHelper;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartXTabUIUtil
extends ChartCubeUtil {
    public static boolean checkQueryExpression(String checkType, Object data, Chart cm, ExtendedItemHandle itemHandle, ReportDataServiceProvider provider) {
        Map<String, Query[]> queryDefinitionsMap = QueryUIHelper.getQueryDefinitionsMap(cm);
        return ChartXTabUIUtil.checkQueryExpression(checkType, data, queryDefinitionsMap, itemHandle, provider);
    }

    public static boolean isTransposedChartWithAxes(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return ((ChartWithAxes)cm).isTransposed();
        }
        throw new IllegalArgumentException(Messages.getString("Error.ChartShouldIncludeAxes"));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkQueryExpression(String checkType, Object data, Map<String, Query[]> queryDefinitionsMap, ExtendedItemHandle itemHandle, ReportDataServiceProvider provider) {
        if (data == null || "".equals(data)) {
            return true;
        }
        exprCodec = ChartModelHelper.instance().createExpressionCodec();
        categoryDimension = null;
        yOptionDimension = null;
        categoryBindName = null;
        yOptionBindName = null;
        expression = (String)data;
        columnBindings = null;
        if (ChartXTabUIUtil.getBindingCube((DesignElementHandle)itemHandle) != null && provider.isInheritanceOnly() || provider.isSharedBinding()) {
            reportItemHandle = provider.getReportItemHandle();
            columnBindings = reportItemHandle.getColumnBindings().iterator();
        } else if (ChartXTabUIUtil.getBindingCube((DesignElementHandle)itemHandle) != null || provider.isInXTabMeasureCell() && !provider.isPartChart()) {
            columnBindings = ChartXTabUIUtil.getAllColumnBindingsIterator((ReportItemHandle)itemHandle);
        }
        if ("optional".equals(checkType)) {
            categoryExpr = null;
            querys = queryDefinitionsMap.get("category");
            if (querys != null && querys.length > 0) {
                categoryExpr = querys[0].getDefinition();
            }
            if (categoryExpr == null || "".equals(categoryExpr)) {
                return true;
            }
            categoryBindName = exprCodec.getCubeBindingName(categoryExpr, true);
            yOptionBindName = exprCodec.getCubeBindingName(expression, true);
        } else if ("category".equals(checkType)) {
            yOptionExpr = null;
            querys = queryDefinitionsMap.get("optional");
            if (querys != null && querys.length > 0) {
                yOptionExpr = querys[0].getDefinition();
            }
            if (yOptionExpr == null || "".equals(yOptionExpr)) {
                return true;
            }
            categoryBindName = exprCodec.getCubeBindingName(expression, true);
            yOptionBindName = exprCodec.getCubeBindingName(yOptionExpr, true);
        }
        if (columnBindings != null) ** GOTO lbl46
        return true;
lbl-1000:
        // 1 sources

        {
            columnHandle = (ComputedColumnHandle)columnBindings.next();
            ChartItemUtil.loadExpression((ChartExpressionUtil.ExpressionCodec)exprCodec, (ComputedColumnHandle)columnHandle);
            bindName = columnHandle.getName();
            if (!exprCodec.isDimensionExpresion()) continue;
            if (bindName.equals(categoryBindName)) {
                categoryDimension = exprCodec.getLevelNames()[0];
            }
            if (!bindName.equals(yOptionBindName)) continue;
            yOptionDimension = exprCodec.getLevelNames()[0];
lbl46:
            // 4 sources

            ** while (columnBindings.hasNext())
        }
lbl47:
        // 1 sources

        return categoryDimension == null || yOptionDimension == null || categoryDimension.equals(yOptionDimension) == false;
    }

    public static List<String> getLevelNamesInDimension(String cubeBinding, CubeHandle cube, boolean includeSelf, boolean useFullName) throws BirtException {
        if (cubeBinding == null || cube == null) {
            return Collections.emptyList();
        }
        List bindings = ExpressionUtil.extractColumnExpressions((String)cubeBinding, (String)"data");
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        String levelFullName = ((IColumnBinding)bindings.get(0)).getResultSetColumnName();
        String[] names = levelFullName.split("/");
        if (names.length < 2) {
            return Collections.emptyList();
        }
        String dimensionName = names[0];
        if (cube.getContentCount("dimensions") <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> levelNames = new ArrayList<String>();
        for (DimensionHandle dimensionHandle : cube.getContents("dimensions")) {
            if (!dimensionName.equals(dimensionHandle.getName())) continue;
            HierarchyHandle hierarchy = (HierarchyHandle)dimensionHandle.getContent("hierarchies", 0);
            int count = hierarchy.getLevelCount();
            int i = 0;
            while (i < count) {
                String fullName = hierarchy.getLevel(i).getFullName();
                if (includeSelf || !fullName.equals(levelFullName)) {
                    if (!useFullName) {
                        levelNames.add(hierarchy.getLevel(i).getName());
                    } else {
                        levelNames.add(fullName);
                    }
                }
                ++i;
            }
            return levelNames;
        }
        return Collections.emptyList();
    }

    private static void correctBindingName(ComputedColumn column, Set<String> nameSet) {
        String name = column.getName();
        if (nameSet.contains(name)) {
            String newName = name;
            try {
                int num = Integer.valueOf(name.substring(name.length() - 1, name.length()));
                newName = String.valueOf(name.substring(0, name.length() - 1)) + String.valueOf(num + 1);
            }
            catch (Exception exception) {
                newName = String.valueOf(name) + "1";
            }
            column.setName(newName);
            nameSet.add(newName);
        } else {
            nameSet.add(name);
        }
    }

    public static List<ComputedColumn> generateComputedColumns(ExtendedItemHandle itemHandle, CubeHandle cubeHandle) {
        if (cubeHandle != null) {
            HashSet<String> bindingNameSet = new HashSet<String>();
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            String exprType = UIUtil.getDefaultScriptType();
            IExpressionConverter exprConverter = ExpressionUtility.getExpressionConverter((String)exprType);
            for (LevelHandle levelHandle : ChartCubeUtil.getAllLevels((CubeHandle)cubeHandle)) {
                String displayNameAttr = null;
                String dataType = levelHandle.getDataType();
                if (levelHandle instanceof TabularLevelHandle && ((TabularLevelHandle)levelHandle).getDisplayColumnName() != null && ((TabularLevelHandle)levelHandle).getDisplayColumnName().trim().length() > 0) {
                    displayNameAttr = "DisplayName";
                    dataType = "string";
                }
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)itemHandle, (String)ChartCubeUtil.createLevelBindingName((LevelHandle)levelHandle));
                column.setDataType(dataType);
                column.setExpressionProperty("expression", new Expression((Object)exprConverter.getDimensionExpression(levelHandle.getContainer().getContainer().getName(), levelHandle.getName(), displayNameAttr), exprType));
                ChartXTabUIUtil.correctBindingName(column, bindingNameSet);
                columnList.add(column);
                Iterator itLevelAttr = levelHandle.attributesIterator();
                while (itLevelAttr.hasNext()) {
                    LevelAttributeHandle laHandle = (LevelAttributeHandle)itLevelAttr.next();
                    ComputedColumn columnLA = StructureFactory.newComputedColumn((DesignElementHandle)itemHandle, (String)ChartCubeUtil.createLevelAttrBindingName((LevelHandle)levelHandle, (LevelAttributeHandle)laHandle));
                    columnLA.setDataType(laHandle.getDataType());
                    columnLA.setExpressionProperty("expression", new Expression((Object)exprConverter.getDimensionExpression(levelHandle.getContainer().getContainer().getName(), levelHandle.getName(), laHandle.getName()), exprType));
                    ChartXTabUIUtil.correctBindingName(columnLA, bindingNameSet);
                    columnList.add(columnLA);
                }
            }
            for (MeasureHandle measureHandle : ChartCubeUtil.getAllMeasures((CubeHandle)cubeHandle)) {
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)itemHandle, (String)ChartCubeUtil.createMeasureBindingName((MeasureHandle)measureHandle));
                column.setDataType(measureHandle.getDataType());
                column.setExpressionProperty("expression", new Expression((Object)exprConverter.getMeasureExpression(measureHandle.getName()), exprType));
                column.setAggregateFunction(DataAdapterUtil.getRollUpAggregationName((String)measureHandle.getFunction()));
                ChartXTabUIUtil.correctBindingName(column, bindingNameSet);
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }
}

