/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.ValidationRecordTask;
import org.eclipse.birt.report.model.api.activity.IEventFilter;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.validators.ValidationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundRecord
extends ActivityRecord {
    private List<ActivityRecord> recordList = new ArrayList<ActivityRecord>();
    protected TransactionOption options = null;

    public CompoundRecord(String text) {
        this.label = text;
    }

    public CompoundRecord(String text, boolean isPersistent) {
        this.label = text;
        this.isPersistent = isPersistent;
    }

    public List<ActivityRecord> getRecords() {
        return this.recordList;
    }

    @Override
    public void execute() {
        assert (this.checkState(1));
    }

    @Override
    public void undo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        int i = this.recordList.size() - 1;
        while (i >= 0) {
            ActivityRecord record = this.recordList.get(i);
            assert (record.getState() == 1 || record.getState() == 3);
            record.undo();
            record.setState(2);
            record.performPostTasks(stack);
            --i;
        }
    }

    @Override
    public void redo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        int i = 0;
        while (i < this.recordList.size()) {
            ActivityRecord record = this.recordList.get(i);
            assert (record.getState() == 2);
            record.redo();
            record.setState(3);
            record.performPostTasks(stack);
            ++i;
        }
    }

    private boolean checkState(int state) {
        for (ActivityRecord cmd : this.recordList) {
            if (cmd.getState() == state) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUndo() {
        ListIterator<ActivityRecord> records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRedo() {
        ListIterator<ActivityRecord> records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canRedo()) continue;
            return false;
        }
        return true;
    }

    public void append(ActivityRecord record) {
        assert (record != null);
        assert (record.getState() == 1);
        this.recordList.add(record);
    }

    public List<ActivityRecord> getDonePersistentTrans() {
        ArrayList<ActivityRecord> allDonePersistentRecords = new ArrayList<ActivityRecord>();
        ActivityRecord record = null;
        int i = 0;
        while (i < this.recordList.size()) {
            record = this.recordList.get(i);
            if (record.isPersistent && record.state == 1) {
                allDonePersistentRecords.add(record);
            } else if (record instanceof CompoundRecord) {
                allDonePersistentRecords.addAll(((CompoundRecord)record).getDonePersistentTrans());
            }
            ++i;
        }
        return allDonePersistentRecords;
    }

    public boolean isEmpty() {
        return this.recordList.isEmpty();
    }

    public int getCount() {
        return this.recordList.size();
    }

    public ActivityRecord pop() {
        if (this.recordList.isEmpty()) {
            return null;
        }
        return this.recordList.remove(this.recordList.size() - 1);
    }

    @Override
    public List<ValidationNode> getValidators() {
        ArrayList<ValidationNode> list = new ArrayList<ValidationNode>();
        for (ActivityRecord record : this.recordList) {
            list.addAll(record.getValidators());
        }
        return list;
    }

    @Override
    public void rollback() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        int i = this.recordList.size() - 1;
        while (i >= 0) {
            ActivityRecord record = this.recordList.get(i);
            if (!record.isPersistent()) {
                record.rollback();
                record.performPostTasks(stack);
            }
            --i;
        }
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        int i = this.recordList.size() - 1;
        while (i >= 0) {
            ActivityRecord record = this.recordList.get(i);
            retList.addAll(record.getPostTasks());
            --i;
        }
        return retList;
    }

    @Override
    protected void performPostTasks(Stack<CompoundRecord> transStack) {
        List<RecordTask> simpleTasks = this.getPostTasks();
        ArrayList<RecordTask> validationTasks = new ArrayList<RecordTask>();
        int i = 0;
        while (i < simpleTasks.size()) {
            RecordTask task = simpleTasks.get(i);
            if (task instanceof ValidationRecordTask) {
                validationTasks.add(task);
            }
            ++i;
        }
        if (this instanceof FilterEventsCompoundRecord && transStack.isEmpty()) {
            assert (this.options != null);
            IEventFilter filter = this.options.getEventFilter();
            assert (filter != null);
            this.doTasks(transStack, filter.filter(this.getNotificationTask(simpleTasks)));
        } else if (this.options != null && this.options.getSendTime() != 0) {
            this.doTasks(transStack, this.getFilterNotificationTask());
        } else if (this.options == null && (transStack == null || transStack.isEmpty())) {
            this.doTasks(transStack, this.getNotificationTask(simpleTasks));
        }
        if (!validationTasks.isEmpty()) {
            ((RecordTask)validationTasks.get(0)).doTask(this, transStack);
        }
    }

    private List<RecordTask> getFilterNotificationTask() {
        IEventFilter filter;
        List<RecordTask> events = new ArrayList<RecordTask>();
        int i = 0;
        while (i < this.recordList.size()) {
            ActivityRecord record = this.recordList.get(i);
            if (record instanceof AbstractElementRecord) {
                events.addAll(this.getNotificationTask(record.getPostTasks()));
            } else if (record instanceof CompoundRecord) {
                CompoundRecord cr = (CompoundRecord)record;
                if (cr instanceof FilterEventsCompoundRecord || cr instanceof LayoutCompoundRecord) {
                    if (!((FilterEventsCompoundRecord)cr).isOutermostFilterTrans) {
                        events.addAll(cr.getFilterNotificationTask());
                    }
                } else {
                    TransactionOption options = cr.getOptions();
                    if (options != null && options.getSendTime() == 2) {
                        events.addAll(cr.getFilterNotificationTask());
                    }
                }
            }
            ++i;
        }
        if (this.options != null && (filter = this.options.getEventFilter()) != null) {
            events = filter.filter(events);
        }
        return events;
    }

    private List<RecordTask> getNotificationTask(List<RecordTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RecordTask> events = new ArrayList<RecordTask>();
        int i = 0;
        while (i < tasks.size()) {
            RecordTask task = tasks.get(i);
            if (task instanceof NotificationRecordTask) {
                events.add(task);
            }
            ++i;
        }
        return events;
    }

    protected void doTasks(Stack<CompoundRecord> transStack, List<? extends RecordTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < tasks.size()) {
            RecordTask task = tasks.get(i);
            task.doTask(this, transStack);
            ++i;
        }
    }

    public TransactionOption getOptions() {
        return this.options;
    }

    public void setOptions(TransactionOption options) {
        this.options = options;
    }
}

